/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.log.ExoLogger;

public class ChildVersionRemoveVisitor
extends ItemDataTraversingVisitor {
    private final Log log = ExoLogger.getLogger((String)"jcr.ChildVersionRemoveVisitor");
    protected final Stack<NodeData> parents = new Stack();
    protected final NodeTypeManagerImpl ntManager;
    protected final QPath ancestorToSave;
    protected final QPath containingHistory;
    protected final SessionImpl userSession;

    public ChildVersionRemoveVisitor(SessionImpl userSession, QPath containingHistory, QPath ancestorToSave) throws RepositoryException {
        super(userSession.getTransientNodesManager());
        this.ancestorToSave = ancestorToSave;
        this.containingHistory = containingHistory;
        this.userSession = userSession;
        this.ntManager = userSession.getWorkspace().getNodeTypeManager();
    }

    protected SessionDataManager dataManager() {
        return (SessionDataManager)this.dataManager;
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (property.getQPath().getName().equals((Object)Constants.JCR_CHILDVERSIONHISTORY) && this.ntManager.isNodeType(Constants.NT_VERSIONEDCHILD, this.parents.peek().getPrimaryTypeName(), this.parents.peek().getMixinTypeNames())) {
            try {
                String vhID = new String(property.getValues().get(0).getAsByteArray());
                this.dataManager().removeVersionHistory(vhID, this.containingHistory, this.ancestorToSave);
            }
            catch (IOException e) {
                throw new RepositoryException("Child version history UUID read error " + e, (Throwable)e);
            }
        }
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        this.parents.push(node);
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }
}

