/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.importing.ContentImporter;
import org.exoplatform.services.jcr.impl.xml.importing.NeutralImporter;
import org.exoplatform.services.jcr.impl.xml.importing.RawDataImporter;
import org.exoplatform.services.log.ExoLogger;

public class StreamImporter
implements RawDataImporter {
    private final Log log = ExoLogger.getLogger((String)"jcr.StreamImporter");
    private final ContentImporter importer;
    private boolean namespacesRegistered = false;

    public StreamImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        this.importer = this.createContentImporter(parent, uuidBehavior, saveType, context);
    }

    public ContentImporter createContentImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        return new NeutralImporter(parent, uuidBehavior, saveType, context);
    }

    public void importStream(InputStream stream) throws RepositoryException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("FACTORY: " + factory));
        }
        try {
            XMLEventReader reader = factory.createXMLEventReader(stream);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Start event handling");
            }
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        StartElement element = event.asStartElement();
                        if (!this.namespacesRegistered) {
                            this.namespacesRegistered = true;
                            this.registerNamespaces(element);
                        }
                        Iterator<Attribute> attributes = element.getAttributes();
                        HashMap<String, String> attr = new HashMap<String, String>();
                        while (attributes.hasNext()) {
                            Attribute attribute = attributes.next();
                            attr.put(attribute.getName().getPrefix() + ":" + attribute.getName().getLocalPart(), attribute.getValue());
                        }
                        QName name = element.getName();
                        this.importer.startElement(name.getNamespaceURI(), name.getLocalPart(), name.getPrefix() + ":" + name.getLocalPart(), attr);
                        break;
                    }
                    case 2: {
                        EndElement endElement = event.asEndElement();
                        this.importer.endElement(endElement.getName().getNamespaceURI(), endElement.getName().getLocalPart(), endElement.getName().getPrefix() + ":" + endElement.getName().getLocalPart());
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        String chars = event.asCharacters().getData();
                        this.importer.characters(chars.toCharArray(), 0, chars.length());
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        this.importer.save();
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Event handling finished");
            }
        }
        catch (XMLStreamException e) {
            throw new InvalidSerializedDataException("ImportXML failed", (Throwable)e);
        }
    }

    private void registerNamespaces(StartElement event) {
        Iterator<Namespace> iter = event.getNamespaces();
        while (iter.hasNext()) {
            Namespace namespace = iter.next();
            this.importer.registerNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }
}

