/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerService {
    private Map<String, List<Listener>> listeners_ = new HashMap<String, List<Listener>>();

    public void addListener(Listener listener) {
        String name = listener.getName();
        List<Listener> list = this.listeners_.get(name);
        if (list == null) {
            list = new ArrayList<Listener>();
            this.listeners_.put(name, list);
        }
        list.add(listener);
    }

    public void addListener(String name, Listener listener) {
        listener.setName(name);
        this.addListener(listener);
    }

    public final <S, D> void broadcast(String name, S source, D data) throws Exception {
        List<Listener> list = this.listeners_.get(name);
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            listener.onEvent(new Event<S, D>(name, source, data));
        }
    }

    public final <T extends Event> void broadcast(T event) throws Exception {
        List<Listener> list = this.listeners_.get(event.getEventName());
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            listener.onEvent(event);
        }
    }
}

