/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseURLImp
implements BaseURL {
    protected String baseURL;
    protected Map<String, String[]> parameters = new HashMap<String, String[]>();
    private Map<String, List<String>> properties = new HashMap<String, List<String>>();
    private boolean isSecure;
    private boolean setSecureCalled;
    private String type;
    private boolean isCurrentlySecured;
    private boolean defaultEscapeXml = true;
    private final Portlet portletDatas;

    public BaseURLImp(String type, String baseURL, boolean isCurrentlySecured, boolean defaultEscapeXml, Portlet portletDatas) {
        this.setType(type);
        this.baseURL = baseURL;
        this.setCurrentlySecured(isCurrentlySecured);
        this.defaultEscapeXml = defaultEscapeXml;
        this.portletDatas = portletDatas;
    }

    public final void setParameter(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        this.parameters.put(name, new String[]{value});
    }

    public final void setParameter(String name, String[] values) {
        if (name == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        this.parameters.put(name, values);
    }

    public final void setParameters(Map<String, String[]> map) {
        if (map == null) {
            throw new IllegalArgumentException("the map given is null");
        }
        if (map.containsKey(null)) {
            throw new IllegalArgumentException("the map given contains a null key");
        }
        Set<String> keys = map.keySet();
        for (String string : keys) {
            if (string instanceof String) continue;
            throw new IllegalArgumentException("the map contains a non String key");
        }
        Collection<String[]> values = map.values();
        for (String[] name : values) {
            if (name instanceof String[]) continue;
            throw new IllegalArgumentException("the map contains a non String[] value");
        }
        this.parameters = map;
    }

    public final Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public final void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("the property key given is null");
        }
        List<String> propvalues = this.properties.get(key);
        if (propvalues == null) {
            propvalues = new ArrayList<String>();
        }
        propvalues.add(value);
        this.properties.put(key, propvalues);
    }

    public final void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("the property key given is null");
        }
        ArrayList<String> propvalues = new ArrayList<String>();
        propvalues.add(value);
        this.properties.put(key, propvalues);
    }

    public final String getPropertyString() {
        return this.getPropertyString(this.defaultEscapeXml);
    }

    public final String getPropertyString(boolean escapeXML) {
        StringBuffer sb = new StringBuffer();
        try {
            Set<String> names = this.properties.keySet();
            for (String name : names) {
                List<String> propvalues = this.properties.get(name);
                for (int i = 0; i <= propvalues.size(); ++i) {
                    sb.append("&");
                    sb.append("property:");
                    sb.append(this.encode(name, escapeXML));
                    sb.append("=");
                    sb.append(this.encode(propvalues.get(i), escapeXML));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public final void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
        this.setSetSecureCalled(true);
    }

    public abstract String toString(boolean var1);

    public String toString() {
        return this.toString(this.defaultEscapeXml);
    }

    protected String encode(String s, boolean escapeXML) {
        if (s == null || s == "") {
            return "";
        }
        if (escapeXML) {
            s = this.encodeChars(s);
        }
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    protected final String encode(String s) {
        return this.encode(s, false);
    }

    protected final String encodeChars(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&#034;").replace("'", "&#039;");
    }

    public final void write(Writer out) throws IOException {
        out.write(this.toString(this.defaultEscapeXml));
    }

    public final void write(Writer out, boolean escapeXML) throws IOException {
        out.write(this.toString(escapeXML));
    }

    protected Portlet getPortletDatas() {
        return this.portletDatas;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected String getType() {
        return this.type;
    }

    protected void setCurrentlySecured(boolean isCurrentlySecured) {
        this.isCurrentlySecured = isCurrentlySecured;
    }

    protected boolean isCurrentlySecured() {
        return this.isCurrentlySecured;
    }

    protected void setSetSecureCalled(boolean setSecureCalled) {
        this.setSecureCalled = setSecureCalled;
    }

    protected boolean isSetSecureCalled() {
        return this.setSecureCalled;
    }

    protected boolean isSecure() {
        return this.isSecure;
    }
}

