/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InstanceResolver {
    private Map cache = Collections.synchronizedMap(new HashMap());
    private static final Object NO_METHOD = new Object();

    public Object resolve(Object object) {
        if (object == null) {
            return null;
        }
        Method method = this.findReadResolveMethod(object.getClass());
        if (method != null) {
            try {
                return method.invoke(object, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ObjectAccessException("Could not call " + object.getClass().getName() + ".readResolve()", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ObjectAccessException("Could not call " + object.getClass().getName() + ".readResolve()", invocationTargetException);
            }
        }
        return object;
    }

    private Method findReadResolveMethod(Class clazz) {
        if (this.cache.containsKey(clazz)) {
            Object v = this.cache.get(clazz);
            return v == NO_METHOD ? null : v;
        }
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod("readResolve", null);
                method.setAccessible(true);
                this.cache.put(clazz, method);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        this.cache.put(clazz, NO_METHOD);
        return null;
    }
}

