/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.BaseExoCache;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheConfigPlugin;
import org.exoplatform.services.cache.SimpleExoCache;
import org.exoplatform.services.cache.impl.DistributedCacheListener;

public class CacheServiceImpl
implements CacheService {
    private HashMap<String, ExoCacheConfig> configs_ = new HashMap();
    private HashMap<String, ExoCache> cacheMap_ = new HashMap();
    private ExoCacheConfig defaultConfig_;
    private DistributedCacheListener distrbutedListener_;

    public CacheServiceImpl(InitParams params) throws Exception {
        List configs = params.getObjectParamValues(ExoCacheConfig.class);
        for (int i = 0; i < configs.size(); ++i) {
            ExoCacheConfig config = (ExoCacheConfig)configs.get(i);
            this.configs_.put(config.getName(), config);
        }
        this.defaultConfig_ = this.configs_.get("default");
    }

    public void addExoCacheConfig(ComponentPlugin plugin) {
        this.addExoCacheConfig((ExoCacheConfigPlugin)plugin);
    }

    public void addExoCacheConfig(ExoCacheConfigPlugin plugin) {
        List<ExoCacheConfig> configs = plugin.getConfigs();
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
    }

    public void setDistributedCacheListener(DistributedCacheListener listener) {
        this.distrbutedListener_ = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExoCache getCacheInstance(String region) throws Exception {
        if (region == null || region.length() == 0) {
            throw new Exception("region cannot be empty");
        }
        ExoCache cache = this.cacheMap_.get(region);
        if (cache == null) {
            HashMap<String, ExoCache> hashMap = this.cacheMap_;
            synchronized (hashMap) {
                ExoCacheConfig config = this.configs_.get(region);
                if (config == null) {
                    config = this.defaultConfig_;
                }
                cache = this.createCacheInstance(region);
                this.cacheMap_.put(region, cache);
            }
        }
        return cache;
    }

    private synchronized ExoCache createCacheInstance(String region) throws Exception {
        ExoCacheConfig config = this.configs_.get(region);
        if (config == null) {
            config = this.defaultConfig_;
        }
        ExoCache simple = null;
        if (config.getImplementation() == null) {
            simple = new SimpleExoCache();
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(config.getImplementation());
            simple = (ExoCache)clazz.newInstance();
        }
        simple.setName(region);
        simple.setLabel(config.getLabel());
        simple.setMaxSize(config.getMaxSize());
        simple.setLiveTime(config.getLiveTime());
        simple.setReplicated(config.isRepicated());
        simple.setDistributed(config.isDistributed());
        if (simple.isDistributed()) {
            simple.addCacheListener(this.distrbutedListener_);
        }
        return simple;
    }

    public Collection getAllCacheInstances() throws Exception {
        return this.cacheMap_.values();
    }

    public synchronized void synchronize(String region, Serializable key, Object value) throws Exception {
        BaseExoCache cache = (BaseExoCache)this.getCacheInstance(region);
        if (key == null) {
            cache.localClear();
        } else if (value == null) {
            cache.localRemove(key);
        } else {
            cache.localPut(key, value);
        }
    }
}

