/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.encryption;

import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;

public abstract class PDEncryptionDictionary {
    public static final int VERSION0_UNDOCUMENTED_UNSUPPORTED = 0;
    public static final int VERSION1_40_BIT_ALGORITHM = 1;
    public static final int VERSION2_VARIABLE_LENGTH_ALGORITHM = 2;
    public static final int VERSION3_UNPUBLISHED_ALGORITHM = 3;
    public static final int VERSION4_SECURITY_HANDLER = 4;
    public static final String DEFAULT_NAME = "Standard";
    public static final int DEFAULT_LENGTH = 40;
    public static final int DEFAULT_VERSION = 0;
    protected COSDictionary encryptionDictionary = null;

    protected PDEncryptionDictionary(COSDictionary dictionary) {
        this.encryptionDictionary = dictionary;
    }

    protected PDEncryptionDictionary() {
        this.encryptionDictionary = new COSDictionary();
        this.setLength(40);
        this.setVersion(0);
    }

    public COSDictionary getCOSDictionary() {
        return this.encryptionDictionary;
    }

    public String getFilter() {
        String filter = DEFAULT_NAME;
        COSName cosFilter = (COSName)this.encryptionDictionary.getDictionaryObject(COSName.FILTER);
        if (cosFilter != null) {
            filter = cosFilter.getName();
        }
        return filter;
    }

    public int getVersion() {
        int version = 0;
        COSNumber cosVersion = (COSNumber)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("V"));
        if (cosVersion != null) {
            version = cosVersion.intValue();
        }
        return version;
    }

    public void setVersion(int version) {
        this.encryptionDictionary.setItem(COSName.getPDFName("V"), (COSBase)new COSInteger(version));
    }

    public int getLength() {
        int length = 40;
        COSNumber cosLength = (COSNumber)this.encryptionDictionary.getDictionaryObject(COSName.LENGTH);
        if (cosLength != null) {
            length = cosLength.intValue();
        }
        return length;
    }

    public void setLength(int length) {
        this.encryptionDictionary.setItem(COSName.LENGTH, (COSBase)new COSInteger(length));
    }
}

