/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.UIManagement;
import org.exoplatform.portal.webui.UIWelcomeComponent;
import org.exoplatform.portal.webui.navigation.UIPageManagement;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.page.UIPageEditBar;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIToolbar;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIToolbar.gtmpl", events={@EventConfig(listeners={BackActionListener.class}), @EventConfig(listeners={RollbackActionListener.class}), @EventConfig(listeners={AbortActionListener.class}), @EventConfig(listeners={FinishActionListener.class})})
public class UIPageNavigationControlBar
extends UIToolbar {
    public UIPageNavigationControlBar() throws Exception {
        this.setToolbarStyle("ControlToolbar");
        this.setJavascript("Preview", "onClick='eXo.portal.UIPortal.switchMode(this);'");
    }

    public void abort(Event<UIPageNavigationControlBar> event) throws Exception {
        UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPageNavigationControlBar)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
        uiPortalApp.setEditting(false);
        PortalRequestContext prContext = Util.getPortalRequestContext();
        UIPortal portal = Util.getUIPortal();
        UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
        UIControlWorkspace.UIControlWSWorkingArea uiWorking = (UIControlWorkspace.UIControlWSWorkingArea)uiControl.getChildById(UIControlWorkspace.WORKING_AREA_ID);
        uiWorking.setUIComponent(uiWorking.createUIComponent(UIWelcomeComponent.class, null, null));
        prContext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
        UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        UserPortalConfigService configService = (UserPortalConfigService)uiPortalApp.getApplicationComponent(UserPortalConfigService.class);
        portal.setNavigation(configService.getUserPortalConfig(portal.getName(), prContext.getRemoteUser()).getNavigations());
        uiWorkingWS.setRenderedChild(UIPortal.class);
        prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        prContext.setFullRender(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbortActionListener
    extends EventListener<UIPageNavigationControlBar> {
        public void execute(Event<UIPageNavigationControlBar> event) throws Exception {
            UIPageNavigationControlBar uiControlBar = (UIPageNavigationControlBar)((Object)event.getSource());
            uiControlBar.abort(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FinishActionListener
    extends EventListener<UIPageNavigationControlBar> {
        public void execute(Event<UIPageNavigationControlBar> event) throws Exception {
            UIPageManagement uiPageManagement = (UIPageManagement)((UIPageNavigationControlBar)((Object)event.getSource())).getParent();
            ((UIPageEditBar)uiPageManagement.getChild(UIPageEditBar.class)).savePage();
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageManagement.getChild(UIPageNodeSelector.class);
            UserPortalConfigService dataService = (UserPortalConfigService)uiPageManagement.getApplicationComponent(UserPortalConfigService.class);
            List<PageNavigation> deleteNavigations = uiNodeSelector.getDeleteNavigations();
            for (PageNavigation nav : deleteNavigations) {
                if (dataService.getPageNavigation(nav.getId()) == null) continue;
                dataService.remove(nav);
            }
            List<PageNavigation> navigations = uiNodeSelector.getPageNavigations();
            String accessUser = event.getRequestContext().getRemoteUser();
            for (PageNavigation nav : navigations) {
                if (dataService.getPageNavigation(nav.getId()) != null) {
                    dataService.update(nav);
                    continue;
                }
                dataService.create(nav);
            }
            UIPortal uiPortal = Util.getUIPortal();
            UserPortalConfig portalConfig = dataService.getUserPortalConfig(uiPortal.getName(), accessUser);
            uiPortal.setNavigation(portalConfig.getNavigations());
            ((UIPageNavigationControlBar)((Object)event.getSource())).abort(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPageNavigationControlBar> {
        public void execute(Event<UIPageNavigationControlBar> event) throws Exception {
            UIPageNavigationControlBar uiPageNav = (UIPageNavigationControlBar)((Object)event.getSource());
            UIPageManagement uiManagement = (UIPageManagement)uiPageNav.getParent();
            PortalRequestContext pContext = (PortalRequestContext)event.getRequestContext();
            UIPageEditBar uiPageEditBar = (UIPageEditBar)uiManagement.getChild(UIPageEditBar.class);
            Class[] childrenToRender = null;
            childrenToRender = uiPageEditBar.isRendered() ? new Class[]{UIPageEditBar.class, UIPageNodeSelector.class, UIPageNavigationControlBar.class} : new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
            uiManagement.setRenderedChildrenOfTypes(childrenToRender);
            pContext.addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageNav.getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            UIPortalToolPanel toolPanel = (UIPortalToolPanel)uiPortalApp.findFirstComponentOfType(UIPortalToolPanel.class);
            toolPanel.setShowMaskLayer(true);
            pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pContext.setFullRender(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RollbackActionListener
    extends EventListener<UIPageNavigationControlBar> {
        public void execute(Event<UIPageNavigationControlBar> event) throws Exception {
            UIPageNavigationControlBar uiPageNav = (UIPageNavigationControlBar)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageNav.getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            UserPortalConfigService configService = (UserPortalConfigService)uiPortalApp.getApplicationComponent(UserPortalConfigService.class);
            PortalRequestContext prcontext = Util.getPortalRequestContext();
            UIPortal oldUIPortal = Util.getUIPortal();
            PageNavigation oldSelectedNavi = oldUIPortal.getSelectedNavigation();
            PageNode oldSelectedNode = oldUIPortal.getSelectedNode();
            String remoteUser = prcontext.getRemoteUser();
            String ownerUser = oldUIPortal.getOwner();
            UserPortalConfig userPortalConfig = configService.getUserPortalConfig(ownerUser, remoteUser);
            UIPortal uiPortal = (UIPortal)uiWorkingWS.createUIComponent(prcontext, UIPortal.class, null, null);
            PortalDataMapper.toUIPortal(uiPortal, userPortalConfig);
            oldUIPortal.setNavigation(uiPortal.getNavigations());
            oldUIPortal.setSelectedNavigation(oldSelectedNavi);
            oldUIPortal.setSelectedNode(oldSelectedNode);
            ArrayList<PageNode> selectedPaths = new ArrayList<PageNode>();
            selectedPaths.add(oldSelectedNode);
            oldUIPortal.setSelectedPaths(selectedPaths);
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UIContainer)uiPageNav.getParent()).findFirstComponentOfType(UIPageNodeSelector.class);
            uiPageNodeSelector.loadNavigations();
            UIPageManagement uiManagement = (UIPageManagement)uiPageNav.getParent();
            Class[] classes = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
            UIPageEditBar uiEditBar = (UIPageEditBar)uiManagement.getChild(UIPageEditBar.class);
            uiEditBar.setUIPage(null);
            uiManagement.setRenderedChildrenOfTypes(classes);
            uiManagement.setMode(UIManagement.ManagementMode.EDIT, event);
        }
    }
}

