/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.jcr.query.InvalidQueryException;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.navigation.UIPageManagement;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageBrowseControlBar;
import org.exoplatform.portal.webui.page.UIPageEditBar;
import org.exoplatform.portal.webui.page.UIPageForm;
import org.exoplatform.portal.webui.page.UIPagePreview;
import org.exoplatform.portal.webui.page.UIPageTemplateOptions;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UISearch;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputItemSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UISearchForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/page/UIPageBrowser.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPageBrowse.deletePage"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={PreviewActionListener.class}), @EventConfig(listeners={AddNewActionListener.class})}), @ComponentConfig(id="UIBrowserPageForm", type=UIPageForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SavePageActionListener.class}, name="Save"), @EventConfig(listeners={UIPageForm.ChangeOwnerTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.ChangeOwnerIdActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="PageTemplate", value="system:/WEB-INF/conf/uiconf/portal/webui/page/PageTemplate.groovy")}), @ComponentConfig(type=UIFormInputSet.class, id="PermissionSetting", template="system:/groovy/webui/core/UITabSelector.gtmpl")})
public class UIPageBrowser
extends UISearch {
    public static String[] BEAN_FIELD = new String[]{"ownerType", "ownerId", "name", "accessPermissions", "editPermission"};
    public static String[] ACTIONS = new String[]{"Preview", "EditInfo", "Delete"};
    private boolean showAddNewPage = false;
    protected String pageSelectedId_;
    private static List<SelectItemOption<String>> OPTIONS = new ArrayList<SelectItemOption<String>>(3);
    private Query<Page> lastQuery_;

    public UIPageBrowser() throws Exception {
        super(OPTIONS);
        ((UISearchForm)this.getChild(UISearchForm.class)).setId("UIPageSearch" + ((Object)((Object)this)).hashCode());
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, null);
        uiGrid.configure("pageId", BEAN_FIELD, ACTIONS);
        UIPageIterator uiIterator = uiGrid.getUIPageIterator();
        this.addChild((UIComponent)uiIterator);
        uiIterator.setId("UIBrowserIterator" + ((Object)((Object)this)).hashCode());
        uiIterator.setRendered(false);
        this.defaultValue(null);
    }

    public Query<Page> getLastQuery() {
        return this.lastQuery_;
    }

    public void defaultValue(Query<Page> query) throws Exception {
        this.lastQuery_ = query;
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        if (this.lastQuery_ == null) {
            this.lastQuery_ = new Query(null, null, null, Page.class);
        }
        PageList pagelist = null;
        try {
            pagelist = service.find(this.lastQuery_, (Comparator)new Comparator<Object>(){

                @Override
                public int compare(Object obj1, Object obj2) {
                    Page page1 = (Page)obj1;
                    Page page2 = (Page)obj2;
                    return page1.getName().compareTo(page2.getName());
                }
            });
        }
        catch (InvalidQueryException e) {
            UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
            uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.InvalidQueryException", null));
            Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        pagelist.setPageSize(10);
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        uiGrid.getUIPageIterator().setPageList(pagelist);
        UIPageIterator pageIterator = uiGrid.getUIPageIterator();
        if (pageIterator.getAvailable() > 0) {
            return;
        }
        UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
        uiApp.addMessage(new ApplicationMessage("UISearchForm.msg.empty", null));
        Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
    }

    public void quickSearch(UIFormInputSet quickSearchInput) throws Exception {
        UIFormStringInput input = (UIFormStringInput)quickSearchInput.getChild(0);
        UIFormSelectBox select = (UIFormSelectBox)quickSearchInput.getChild(1);
        String value = (String)input.getValue();
        String selectBoxValue = (String)select.getValue();
        Query query = new Query(null, null, null, Page.class);
        if (selectBoxValue.equals("ownerType")) {
            query.setOwnerType(value);
        }
        if (selectBoxValue.equals("ownerId")) {
            query.setOwnerId(value);
        }
        if (selectBoxValue.equals("name")) {
            query.setName(value);
        }
        this.lastQuery_ = query;
        this.defaultValue(this.lastQuery_);
        if (this.getParent() instanceof UIPopupWindow) {
            UIPopupWindow popupWindow = (UIPopupWindow)this.getParent();
            popupWindow.setShow(true);
        }
    }

    public boolean isShowAddNewPage() {
        return this.showAddNewPage;
    }

    public void setShowAddNewPage(boolean showAddNewPage) {
        this.showAddNewPage = showAddNewPage;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = null;
        action = uiForm != null ? uiForm.getSubmitAction() : context.getRequestParameter("formOp");
        if (action == null) {
            return;
        }
        Event event = this.createEvent(action, Event.Phase.PROCESS, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public void advancedSearch(UIFormInputSet advancedSearchInput) throws Exception {
    }

    void reset() throws Exception {
        int currentPage;
        UIPageIterator uiPageIterator = (UIPageIterator)this.getChild(UIPageIterator.class);
        this.defaultValue(this.lastQuery_);
        for (currentPage = uiPageIterator.getCurrentPage(); currentPage > uiPageIterator.getAvailablePage(); --currentPage) {
        }
        if (currentPage > 0) {
            uiPageIterator.setCurrentPage(currentPage);
        }
    }

    static {
        OPTIONS.add((SelectItemOption<String>)new SelectItemOption("Owner Type", (Object)"ownerType"));
        OPTIONS.add((SelectItemOption<String>)new SelectItemOption("Owner Id", (Object)"ownerId"));
        OPTIONS.add((SelectItemOption<String>)new SelectItemOption("Name", (Object)"name"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavePageActionListener
    extends UIPageForm.SaveActionListener {
        @Override
        public void execute(Event<UIPageForm> event) throws Exception {
            UIPageForm uiPageForm = (UIPageForm)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageForm.getAncestorOfType(UIPortalApplication.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPage uiPage = uiPageForm.getUIPage();
            Page page = new Page();
            uiPageForm.invokeSetBindingBean(page);
            UserPortalConfigService configService = (UserPortalConfigService)uiPageForm.getApplicationComponent(UserPortalConfigService.class);
            if (uiPage == null) {
                DataStorage dataStorage = (DataStorage)uiPageForm.getApplicationComponent(DataStorage.class);
                Page existPage = dataStorage.getPage(page.getPageId());
                if (existPage != null) {
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageForm.msg.sameName", null));
                    pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                    return;
                }
                page.setCreator(pcontext.getRemoteUser());
                page.setModifiable(true);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                configService.create(page);
                this.postSave(uiPortalApp, pcontext);
                return;
            }
            page.setOwnerType(uiPage.getOwnerType());
            ArrayList<UIPortlet> uiPortlets = new ArrayList<UIPortlet>();
            this.findAllPortlet(uiPortlets, uiPage);
            ArrayList<Application> applications = new ArrayList<Application>();
            for (UIPortlet uiPortlet : uiPortlets) {
                applications.add(PortalDataMapper.toPortletModel(uiPortlet));
            }
            if ("Desktop".equals(uiPage.getFactoryId()) && !"Desktop".equals(page.getFactoryId())) {
                page.setShowMaxWindow(Boolean.valueOf(false));
                uiPage.getChildren().clear();
                page.setChildren(applications);
                page.setModifier(pcontext.getRemoteUser());
                PortalDataMapper.toUIPage(uiPage, page);
                if (page.getTemplate() == null) {
                    page.setTemplate(uiPage.getTemplate());
                }
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                configService.update(page);
                this.postSave(uiPortalApp, pcontext);
                return;
            }
            List uiChildren = uiPage.getChildren();
            if (uiChildren == null) {
                return;
            }
            ArrayList children = new ArrayList();
            for (UIComponent child : uiChildren) {
                Object component = PortalDataMapper.buildChild(child);
                if (component == null) continue;
                children.add(component);
            }
            page.setChildren(children);
            uiPage.getChildren().clear();
            page.setModifier(pcontext.getRemoteUser());
            PortalDataMapper.toUIPage(uiPage, page);
            if (page.getTemplate() == null) {
                page.setTemplate(uiPage.getTemplate());
            }
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            if ("Desktop".equals(uiPage.getFactoryId())) {
                configService.update(page);
                this.postSave(uiPortalApp, pcontext);
            }
        }

        private void postSave(UIPortalApplication uiPortalApp, WebuiRequestContext context) throws Exception {
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            UIPortalToolPanel uiToolPanel = Util.getUIPortalToolPanel();
            UIPageBrowser uiBrowser = (UIPageBrowser)uiToolPanel.getUIComponent();
            uiBrowser.reset();
            context.addUIComponentToUpdateByAjax((UIComponent)uiBrowser);
            context.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNewActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)((UIPageBrowser)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPageForm uiPageForm = uiMaskWS.createUIComponent(UIPageForm.class, "UIBrowserPageForm", "UIPageForm");
            uiMaskWS.setUIComponent((UIComponent)uiPageForm);
            uiPageForm.getUIStringInput("ownerType").setValue((Object)"user");
            uiPageForm.getUIStringInput("ownerId").setValue((Object)prContext.getRemoteUser());
            uiPageForm.removeChildById("PermissionSetting");
            uiPageForm.removeChild(UIFormInputItemSelector.class);
            UIPageTemplateOptions uiTemplateConfig = (UIPageTemplateOptions)uiPageForm.createUIComponent(UIPageTemplateOptions.class, null, null);
            uiPageForm.addUIFormInput((UIFormInput)uiTemplateConfig);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviewActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String id = pcontext.getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            Page page = service.getPage(id, pcontext.getRemoteUser());
            UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPageBrowser)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            if (page == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.null", (Object[])new String[0]));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            if ("Desktop".equals(page.getFactoryId())) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.Invalid-Preview", (Object[])new String[]{page.getName()}));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            UIPage uiPage = (UIPage)uiPageBrowser.createUIComponent(event.getRequestContext(), UIPage.class, null, null);
            PortalDataMapper.toUIPage(uiPage, page);
            UIPortalToolPanel uiToolPanel = Util.getUIPortalToolPanel();
            UIPagePreview uiPagePreview = (UIPagePreview)uiToolPanel.createUIComponent(UIPagePreview.class, "UIPagePreviewWithMessage", null);
            uiPagePreview.setUIComponent((UIComponent)uiPage);
            uiToolPanel.setUIComponent((UIComponent)uiPagePreview);
            uiToolPanel.setShowMaskLayer(true);
            uiToolPanel.setRenderSibbling(UIPortalToolPanel.class);
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.findFirstComponentOfType(UIControlWorkspace.class);
            UIControlWorkspace.UIControlWSWorkingArea uiControlWorking = (UIControlWorkspace.UIControlWSWorkingArea)uiControl.getChildById(UIControlWorkspace.WORKING_AREA_ID);
            UIPageManagement uiManagement = (UIPageManagement)uiControlWorking.findFirstComponentOfType(UIPageManagement.class);
            UIPageBrowseControlBar uiBrowseControlBar = (UIPageBrowseControlBar)uiManagement.getChild(UIPageBrowseControlBar.class);
            uiBrowseControlBar.setComponentConfig(UIPageBrowseControlBar.class, "PagePreviewControlBar");
            uiBrowseControlBar.setBackComponent((UIComponent)uiPageBrowser);
            uiManagement.setRenderedChild(UIPageBrowseControlBar.class);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInfoActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageBrowser.getAncestorOfType(UIPortalApplication.class);
            uiPortalApp.setEditting(true);
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String id = pcontext.getRequestParameter("objectId");
            UserPortalConfigService dao = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            Page page = dao.getPage(id, pcontext.getRemoteUser());
            if (page == null || !page.isModifiable()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.edit.null", (Object[])new String[0]));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            UIPage uiPage = Util.toUIPage(page, (UIComponent)uiPageBrowser);
            UIPageBody uiPageBody = (UIPageBody)uiPortalApp.findFirstComponentOfType(UIPageBody.class);
            if (uiPageBody.getUIComponent() != null) {
                uiPageBody.setUIComponent(null);
            }
            if ("Desktop".equals(page.getFactoryId())) {
                UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
                UIPageForm uiPageForm = uiMaskWS.createUIComponent(UIPageForm.class, "UIBrowserPageForm", "UIPageForm");
                uiPageForm.setValues(uiPage);
                uiMaskWS.setUIComponent((UIComponent)uiPageForm);
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
                return;
            }
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.findFirstComponentOfType(UIControlWorkspace.class);
            UIComponentDecorator uiWorking = (UIComponentDecorator)uiControl.getChildById(UIControlWorkspace.WORKING_AREA_ID);
            UIPageManagement uiManagement = (UIPageManagement)uiWorking.createUIComponent(UIPageManagement.class, null, null);
            uiWorking.setUIComponent((UIComponent)uiManagement);
            uiManagement.setRenderedChildrenOfTypes(new Class[]{UIPageEditBar.class});
            UIPageEditBar uiEditBar = (UIPageEditBar)uiManagement.getChild(UIPageEditBar.class);
            uiEditBar.setUIPage(uiPage);
            uiEditBar.createEvent("EditPortlet", event.getExecutionPhase(), event.getRequestContext()).broadcast();
            UIPageBrowseControlBar uiBrowseControlBar = (UIPageBrowseControlBar)uiManagement.getChild(UIPageBrowseControlBar.class);
            if (uiBrowseControlBar != null) {
                uiBrowseControlBar.setBackComponent((UIComponent)uiPageBrowser);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String id = pcontext.getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            Page page = service.getPage(id, pcontext.getRemoteUser());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageBrowser.getAncestorOfType(UIPortalApplication.class);
            if (page == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.delete.null", (Object[])new String[0]));
                Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            if (!page.isModifiable()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.delete.null", (Object[])new String[]{page.getName()}));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            service.remove(page);
            uiPageBrowser.reset();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPageBrowser);
        }
    }
}

