/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.common;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.services.common.ServiceConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesContainer {
    private static ConcurrentHashMap<String, Object> map = new ConcurrentHashMap();

    public static <T> T get(Class<T> clazz) {
        return ServicesContainer.get(clazz.getName(), clazz);
    }

    public static <T> T get(String id, Class<T> clazz) {
        ServiceConfig.ServiceType type = ServiceConfig.ServiceType.INSTANCE;
        ServiceConfig config = clazz.getAnnotation(ServiceConfig.class);
        if (config != null) {
            type = config.type();
        }
        return ServicesContainer.get(type, id, clazz);
    }

    public static <T> T get(ServiceConfig.ServiceType type, String id, Class<T> clazz) {
        if (type == ServiceConfig.ServiceType.INSTANCE) {
            try {
                return ServicesContainer.create(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (type == ServiceConfig.ServiceType.SINGLE_FINAL) {
            Object service = map.get(id);
            if (service != null) {
                return clazz.cast(service);
            }
            try {
                service = ServicesContainer.create(clazz);
                map.put(id, service);
                return clazz.cast(service);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ThreadSoftReference thread = (ThreadSoftReference)map.get(clazz);
        if (thread == null) {
            thread = new ThreadSoftReference(clazz);
            map.put(id, thread);
        }
        try {
            return clazz.cast(thread.getRef());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T create(Class<T> clazz) throws Exception {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Arrays.sort(constructors, new Comparator<Constructor<T>>(){

            @Override
            public int compare(Constructor<T> cons1, Constructor<T> cons2) {
                return cons1.getParameterTypes().length - cons2.getParameterTypes().length;
            }
        });
        if (constructors.length < 1) {
            throw new Exception("Not constructor in class " + clazz);
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] classes = constructors[0].getParameterTypes();
        if (classes.length < 1) {
            return clazz.newInstance();
        }
        Object[] objs = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            objs[i] = ServicesContainer.get(classes[i]);
        }
        constructor.setAccessible(true);
        return clazz.cast(constructor.newInstance(objs));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadSoftReference<T>
    extends ThreadLocal<SoftReference<T>> {
        private Class<T> clazz;

        private ThreadSoftReference(Class<?> clazz) {
            this.clazz = clazz;
        }

        private T getRef() throws Exception {
            SoftReference<Object> sr = (SoftReference<Object>)this.get();
            if (sr == null || sr.get() == null) {
                sr = new SoftReference<Object>(ServicesContainer.create(this.clazz));
                this.set(sr);
            }
            return sr.get();
        }
    }
}

