/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.util.HashMap;
import java.util.Map;

public class JVM {
    private transient Map classCache = new HashMap();
    private ReflectionProvider reflectionProvider;

    public static boolean is14() {
        float f = Float.parseFloat(System.getProperty("java.version").substring(0, 3));
        return f >= 1.4f;
    }

    public Class loadClass(String string) {
        if (this.classCache.containsKey(string)) {
            return (Class)this.classCache.get(string);
        }
        try {
            Class<?> clazz = Class.forName(string, false, this.getClass().getClassLoader());
            this.classCache.put(string, clazz);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            try {
                if (this.loadClass("sun.misc.Unsafe") != null) {
                    String string = "com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider";
                    this.reflectionProvider = (ReflectionProvider)this.loadClass(string).newInstance();
                } else {
                    this.reflectionProvider = new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException instantiationException) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException illegalAccessException) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return this.reflectionProvider;
    }

    private Object readResolve() {
        this.classCache = new HashMap();
        return this;
    }
}

