/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.access;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlList
implements Externalizable {
    private Log log = ExoLogger.getLogger((String)"jcr.AccessControlList");
    public static final String DELIMITER = ";";
    private String owner;
    private final List<AccessControlEntry> aces;

    public AccessControlList() {
        this(SystemIdentity.SYSTEM);
    }

    AccessControlList(String ownerName) {
        this.owner = ownerName;
        this.aces = new ArrayList<AccessControlEntry>();
        for (String str : PermissionType.ALL) {
            this.aces.add(new AccessControlEntry(SystemIdentity.ANY, str));
        }
    }

    public AccessControlList(String owner, List<AccessControlEntry> aces) {
        this.owner = owner;
        this.aces = aces;
    }

    public boolean hasPermissions() {
        return this.aces != null;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void addPermissions(String rawData) throws RepositoryException {
        StringTokenizer listTokenizer = new StringTokenizer(rawData, DELIMITER);
        if (listTokenizer.countTokens() < 1) {
            throw new RepositoryException("AccessControlList " + rawData + " is empty or have a bad format");
        }
        while (listTokenizer.hasMoreTokens()) {
            String entry = listTokenizer.nextToken();
            StringTokenizer entryTokenizer = new StringTokenizer(entry, " ");
            if (entryTokenizer.countTokens() != 2) {
                throw new RepositoryException("AccessControlEntry " + entry + " is empty or have a bad format");
            }
            this.aces.add(new AccessControlEntry(entryTokenizer.nextToken(), entryTokenizer.nextToken()));
        }
    }

    public void addPermissions(String identity, String[] perm) {
        for (String p : perm) {
            this.aces.add(new AccessControlEntry(identity, p));
        }
    }

    public void removePermissions(String identity) {
        Iterator<AccessControlEntry> iter = this.aces.iterator();
        while (iter.hasNext()) {
            AccessControlEntry a = iter.next();
            if (!a.getIdentity().equals(identity)) continue;
            iter.remove();
        }
    }

    public void removePermissions(String identity, String permission) {
        Iterator<AccessControlEntry> iter = this.aces.iterator();
        while (iter.hasNext()) {
            AccessControlEntry a = iter.next();
            if (!a.getIdentity().equals(identity) || !a.getPermission().equals(permission)) continue;
            iter.remove();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<AccessControlEntry> getPermissionEntries() {
        ArrayList<AccessControlEntry> list = new ArrayList<AccessControlEntry>();
        for (AccessControlEntry entry : this.aces) {
            list.add(new AccessControlEntry(entry.getIdentity(), entry.getPermission()));
        }
        return list;
    }

    public List<String> getPermissions(String identity) {
        ArrayList<String> permissions = new ArrayList<String>();
        for (AccessControlEntry entry : this.aces) {
            if (!entry.getIdentity().equals(identity)) continue;
            permissions.add(entry.getPermission());
        }
        return permissions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlList) {
            AccessControlList another = (AccessControlList)obj;
            return this.dump().equals(another.dump());
        }
        return false;
    }

    public String dump() {
        String res = "OWNER: " + this.owner + "\n";
        for (AccessControlEntry a : this.aces) {
            res = res + a.getAsString() + "\n";
        }
        return res;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        int ownLength = in.readInt();
        if (ownLength != 0) {
            buf = new byte[ownLength];
            in.read(buf);
            this.owner = new String(buf, "UTF-8");
        } else {
            this.owner = null;
        }
        this.aces.clear();
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            buf = new byte[in.readInt()];
            in.read(buf);
            String ident = new String(buf, "UTF-8");
            buf = new byte[in.readInt()];
            in.read(buf);
            String perm = new String(buf, "UTF-8");
            this.aces.add(new AccessControlEntry(ident, perm));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.owner != null) {
            out.writeInt(this.owner.getBytes().length);
            out.write(this.owner.getBytes());
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.aces.size());
        for (AccessControlEntry entry : this.aces) {
            out.writeInt(entry.getIdentity().getBytes().length);
            out.write(entry.getIdentity().getBytes());
            out.writeInt(entry.getPermission().getBytes().length);
            out.write(entry.getPermission().getBytes());
        }
    }
}

