/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.config.ConfigurationPersister;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class RepositoryServiceConfigurationImpl
extends RepositoryServiceConfiguration {
    private ValueParam param;
    private ConfigurationManager configurationService;
    private ConfigurationPersister configurationPersister;

    public RepositoryServiceConfigurationImpl(InitParams params, ConfigurationManager configurationService, InitialContextInitializer initialContextInitializer) throws RepositoryConfigurationException {
        this.param = params.getValueParam("conf-path");
        if (params.getPropertiesParam("working-conf") != null && params.getPropertiesParam("working-conf").getProperty("persisterClassName") != null) {
            try {
                Class<?> configurationPersisterClass = Class.forName(params.getPropertiesParam("working-conf").getProperty("persisterClassName"));
                this.configurationPersister = (ConfigurationPersister)configurationPersisterClass.newInstance();
                this.configurationPersister.init(params.getPropertiesParam("working-conf"));
            }
            catch (InstantiationException e) {
                throw new RepositoryConfigurationException(e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                throw new RepositoryConfigurationException(e.getLocalizedMessage());
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException(e.getLocalizedMessage());
            }
        }
        this.configurationService = configurationService;
        try {
            InputStream jcrConfigurationInputStream = configurationService.getInputStream(this.param.getValue());
            if (this.configurationPersister != null) {
                if (!this.configurationPersister.hasConfig()) {
                    this.configurationPersister.write(jcrConfigurationInputStream);
                }
                this.init(this.configurationPersister.read());
            } else {
                this.init(jcrConfigurationInputStream);
                jcrConfigurationInputStream.close();
            }
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Fail to init from xml! Reason: " + e, e);
        }
    }

    public RepositoryServiceConfigurationImpl(InputStream is) throws RepositoryConfigurationException {
        this.init(is);
    }

    public boolean isRetainable() {
        URL fileURL;
        if (this.configurationPersister != null) {
            return true;
        }
        String strfileUri = this.param.getValue();
        try {
            fileURL = this.configurationService.getURL(strfileUri);
        }
        catch (Exception e) {
            return false;
        }
        return fileURL.getProtocol().equals("file");
    }

    public void retain() throws RepositoryException {
        try {
            if (!this.isRetainable()) {
                throw new RepositoryException("Unsupported  configuration place " + this.configurationService.getURL(this.param.getValue()) + " If you want to save configuration, start repository from standalone file." + " Or persisterClassName not configured");
            }
            OutputStream saveStream = null;
            if (this.configurationPersister != null) {
                saveStream = new ByteArrayOutputStream();
            } else {
                URL filePath = this.configurationService.getURL(this.param.getValue());
                File sourceConfig = new File(filePath.toURI());
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
                File backUp = new File(sourceConfig.getAbsoluteFile() + "_" + format.format(new Date()));
                if (!sourceConfig.renameTo(backUp)) {
                    throw new RepositoryException("Can't back up configuration on path " + sourceConfig.getAbsolutePath());
                }
                saveStream = new FileOutputStream(sourceConfig);
            }
            IBindingFactory bfact = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.marshalDocument((Object)this, "ISO-8859-1", null, saveStream);
            ((OutputStream)saveStream).close();
            if (this.configurationPersister != null) {
                this.configurationPersister.write(new ByteArrayInputStream(saveStream.toByteArray()));
            }
        }
        catch (JiBXException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

