/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionLifecycleListener;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataMoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionCatalog;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionInterceptor;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.impl.xml.ExportImportFactory;
import org.exoplatform.services.jcr.impl.xml.XmlMapping;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;
import org.exoplatform.services.jcr.impl.xml.importing.StreamImporter;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.impl.CredentialsImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SessionImpl
implements ExtendedSession,
NamespaceAccessor {
    private final Log log = ExoLogger.getLogger((String)"jcr.SessionImpl");
    private final RepositoryImpl repository;
    private final CredentialsImpl credentials;
    private final WorkspaceImpl workspace;
    private final Map<String, String> namespaces;
    private final Map<String, String> prefixes;
    private final AccessManager accessManager;
    private final LocationFactory locationFactory;
    private final ValueFactoryImpl valueFactory;
    private final ExoContainer container;
    private final LocationFactory systemLocationFactory;
    private final LockManagerImpl lockManager;
    private final String workspaceName;
    private boolean live;
    private final List<SessionLifecycleListener> lifecycleListeners;
    private final SessionFactory sessionFactory;
    private final String id;
    private final SessionActionInterceptor actionHandler;
    private long lastAccessTime;
    private final SessionRegistry sessionRegistry;
    protected final SessionDataManager dataManager;

    public SessionImpl(String workspaceName, Credentials credentials, ExoContainer container) throws RepositoryException {
        this.workspaceName = workspaceName;
        this.container = container;
        this.live = true;
        this.id = IdGenerator.generate();
        this.repository = (RepositoryImpl)container.getComponentInstanceOfType(RepositoryImpl.class);
        this.systemLocationFactory = (LocationFactory)container.getComponentInstanceOfType(LocationFactory.class);
        this.accessManager = (AccessManager)container.getComponentInstanceOfType(AccessManager.class);
        this.lockManager = (LockManagerImpl)container.getComponentInstanceOfType(LockManagerImpl.class);
        this.sessionFactory = (SessionFactory)container.getComponentInstanceOfType(SessionFactory.class);
        RepositoryEntry repositoryConfig = (RepositoryEntry)container.getComponentInstanceOfType(RepositoryEntry.class);
        WorkspaceFileCleanerHolder cleanerHolder = (WorkspaceFileCleanerHolder)container.getComponentInstanceOfType(WorkspaceFileCleanerHolder.class);
        this.credentials = (CredentialsImpl)credentials;
        this.locationFactory = new LocationFactory(this);
        this.valueFactory = new ValueFactoryImpl(this.locationFactory, repositoryConfig, cleanerHolder);
        this.namespaces = new LinkedHashMap<String, String>();
        this.prefixes = new LinkedHashMap<String, String>();
        ObservationManagerRegistry observationManagerRegistry = (ObservationManagerRegistry)container.getComponentInstanceOfType(ObservationManagerRegistry.class);
        ObservationManagerImpl observationManager = observationManagerRegistry.createObservationManager(this);
        LocalWorkspaceDataManagerStub workspaceDataManager = (LocalWorkspaceDataManagerStub)container.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class);
        this.dataManager = new SessionDataManager(this, workspaceDataManager);
        this.workspace = new WorkspaceImpl(workspaceName, container, this, observationManager);
        this.lifecycleListeners = new ArrayList<SessionLifecycleListener>();
        this.registerLifecycleListener(observationManager);
        this.registerLifecycleListener(this.lockManager);
        SessionActionCatalog catalog = (SessionActionCatalog)((Object)container.getComponentInstanceOfType(SessionActionCatalog.class));
        this.actionHandler = new SessionActionInterceptor(catalog, container);
        this.sessionRegistry = (SessionRegistry)container.getComponentInstanceOfType(SessionRegistry.class);
        this.sessionRegistry.registerSession(this);
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void addLockToken(String lt) {
        this.getLockManager().addLockToken(this.getId(), lt);
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException {
        try {
            JCRPath jcrPath = this.locationFactory.parseAbsPath(absPath);
            AccessControlList acl = this.dataManager.getACL(jcrPath.getInternalPath());
            if (!this.accessManager.hasPermission(acl, actions, this.getUserID())) {
                throw new AccessControlException("Permission denied " + absPath + " : " + actions);
            }
        }
        catch (RepositoryException e) {
            throw new AccessControlException("Could not check permission for " + absPath + " " + (Object)((Object)e));
        }
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws InvalidSerializedDataException, PathNotFoundException, SAXException, RepositoryException {
        BaseXmlExporter exporter = new ExportImportFactory(this).getExportVisitor(XmlMapping.DOCVIEW, contentHandler, skipBinary, noRecurse);
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
        ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
        if (srcItemData == null) {
            throw new PathNotFoundException("No node exists at " + absPath);
        }
        try {
            exporter.export((NodeData)srcItemData);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws InvalidSerializedDataException, IOException, PathNotFoundException, RepositoryException {
        BaseXmlExporter exporter = new ExportImportFactory(this).getExportVisitor(XmlMapping.DOCVIEW, out, skipBinary, noRecurse);
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
        ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
        if (srcItemData == null) {
            throw new PathNotFoundException("No node exists at " + absPath);
        }
        try {
            exporter.export((NodeData)srcItemData);
        }
        catch (Exception e) {
            if (e instanceof RepositoryException) {
                e.printStackTrace();
                throw (RepositoryException)((Object)e);
            }
            if (e instanceof IOException) {
                e.printStackTrace();
                throw (IOException)e;
            }
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
    }

    public void exportWorkspaceSystemView(OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        BaseXmlExporter exporter = new ExportImportFactory(this).getExportVisitor(XmlMapping.BACKUP, out, skipBinary, noRecurse);
        ItemData srcItemData = this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        if (srcItemData == null) {
            throw new PathNotFoundException("Root node not found");
        }
        try {
            exporter.export((NodeData)srcItemData);
        }
        catch (Exception e) {
            if (e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        BaseXmlExporter exporter = new ExportImportFactory(this).getExportVisitor(XmlMapping.SYSVIEW, contentHandler, skipBinary, noRecurse);
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
        ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
        if (srcItemData == null) {
            throw new PathNotFoundException("No node exists at " + absPath);
        }
        try {
            exporter.export((NodeData)srcItemData);
        }
        catch (Exception e) {
            if (e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        BaseXmlExporter exporter = new ExportImportFactory(this).getExportVisitor(XmlMapping.SYSVIEW, out, skipBinary, noRecurse);
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(absPath);
        ItemData srcItemData = this.dataManager.getItemData(srcNodePath.getInternalPath());
        if (srcItemData == null) {
            throw new PathNotFoundException("No node exists at " + absPath);
        }
        try {
            exporter.export((NodeData)srcItemData);
        }
        catch (Exception e) {
            if (e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    public SessionActionInterceptor getActionHandler() {
        return this.actionHandler;
    }

    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.getNamespacePrefixes();
    }

    public Object getAttribute(String name) {
        return this.credentials.getAttribute(name);
    }

    public String[] getAttributeNames() {
        return this.credentials.getAttributeNames();
    }

    public ExoContainer getContainer() {
        return this.container;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getId() {
        return this.id;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, RepositoryException {
        NodeImpl node = (NodeImpl)this.getItem(parentAbsPath);
        if (!node.checkedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (!node.checkLocking()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
        InvocationContext context = new InvocationContext();
        context.put("respectPropertyDefinitionsConstraints", true);
        context.put(InvocationContext.EXO_CONTAINER, this.getContainer());
        context.put(InvocationContext.CURRENT_ITEM, node);
        return new ExportImportFactory(this).getImportHandler(node, uuidBehavior, XmlSaveType.SESSION, context);
    }

    public ItemImpl getItem(String absPath) throws PathNotFoundException, RepositoryException {
        JCRPath loc = this.locationFactory.parseAbsPath(absPath);
        ItemImpl item = this.dataManager.getItem(loc.getInternalPath(), true);
        if (item != null) {
            return item;
        }
        throw new PathNotFoundException("Item not found " + absPath + " in workspace " + this.workspaceName);
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public LocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public LockManagerImpl getLockManager() {
        return this.lockManager;
    }

    public String[] getLockTokens() {
        return this.getLockManager().getLockTokens(this.getId());
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        if (this.prefixes.containsKey(uri)) {
            return this.prefixes.get(uri);
        }
        return this.workspace.getNamespaceRegistry().getPrefix(uri);
    }

    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.getNamespacePrefix(uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        LinkedList<String> allPrefixes = new LinkedList<String>();
        allPrefixes.addAll(this.namespaces.keySet());
        String[] permanentPrefixes = this.workspace.getNamespaceRegistry().getPrefixes();
        for (int i = 0; i < permanentPrefixes.length; ++i) {
            if (this.prefixes.containsKey(this.workspace.getNamespaceRegistry().getURI(permanentPrefixes[i]))) continue;
            allPrefixes.add(permanentPrefixes[i]);
        }
        return allPrefixes.toArray(new String[allPrefixes.size()]);
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        String uri = null;
        if (this.namespaces.size() > 0 && (uri = this.namespaces.get(prefix)) != null) {
            return uri;
        }
        return this.workspace.getNamespaceRegistry().getURI(prefix);
    }

    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException, RepositoryException {
        return this.getNamespaceURI(prefix);
    }

    public NodeImpl getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        ItemImpl item = this.dataManager.getItemByIdentifier(uuid, true);
        if (item != null && item.isNode()) {
            NodeImpl node = (NodeImpl)item;
            node.getUUID();
            return node;
        }
        throw new ItemNotFoundException("Node not found " + uuid + " at " + this.workspaceName);
    }

    public RepositoryImpl getRepository() {
        return this.repository;
    }

    public NodeImpl getRootNode() throws RepositoryException {
        ItemImpl item = this.dataManager.getItemByIdentifier("00exo0jcr0root0uuid0000000000000", true);
        if (item != null && item.isNode()) {
            return (NodeImpl)item;
        }
        throw new ItemNotFoundException("Node not found / at " + this.workspaceName);
    }

    public String getSessionInfo() {
        return this.getUserID() + "@" + this.workspaceName;
    }

    public SessionDataManager getTransientNodesManager() {
        return this.dataManager;
    }

    public String getUserID() {
        return this.credentials.getUserID();
    }

    public ValueFactoryImpl getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.valueFactory;
    }

    public WorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return this.dataManager.hasPendingChanges(Constants.ROOT_PATH);
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        if (credentials instanceof CredentialsImpl) {
            return this.sessionFactory.createSession((CredentialsImpl)credentials);
        }
        if (credentials instanceof SimpleCredentials) {
            String name = ((SimpleCredentials)credentials).getUserID();
            char[] pswd = ((SimpleCredentials)credentials).getPassword();
            CredentialsImpl thisCredentials = new CredentialsImpl(name, pswd);
            return this.sessionFactory.createSession(thisCredentials);
        }
        throw new LoginException("Credentials for the authentication should be CredentialsImpl or SimpleCredentials type");
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        InvocationContext context = new InvocationContext();
        context.put("respectPropertyDefinitionsConstraints", true);
        this.importXML(parentAbsPath, in, uuidBehavior, context);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior, boolean respectPropertyDefinitionsConstraints) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        InvocationContext context = new InvocationContext();
        context.put("respectPropertyDefinitionsConstraints", respectPropertyDefinitionsConstraints);
        this.importXML(parentAbsPath, in, uuidBehavior, context);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior, InvocationContext context) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        NodeImpl node = (NodeImpl)this.getItem(parentAbsPath);
        if (!node.checkedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (!node.checkLocking()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
        context.put(InvocationContext.EXO_CONTAINER, this.getContainer());
        context.put(InvocationContext.CURRENT_ITEM, node);
        StreamImporter importer = new ExportImportFactory(this).getStreamImporter(node, uuidBehavior, XmlSaveType.SESSION, context);
        importer.importStream(in);
    }

    public boolean isLive() {
        return this.live;
    }

    public boolean itemExists(String absPath) {
        try {
            if (this.getItem(absPath) != null) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public void logout() {
        for (int i = 0; i < this.lifecycleListeners.size(); ++i) {
            this.lifecycleListeners.get(i).onCloseSession(this);
        }
        this.sessionRegistry.unregisterSession(this.getId());
        this.live = false;
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, LockException, RepositoryException {
        JCRPath srcNodePath = this.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)this.dataManager.getItem(srcNodePath.getInternalPath(), false);
        JCRPath destNodePath = this.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + destNodePath.getAsString(false));
        }
        NodeImpl destParentNode = (NodeImpl)this.dataManager.getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((ExtendedNodeType)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.dataManager.getItem((NodeData)destParentNode.getData(), new QPathEntry(destNodePath.getInternalPath().getName(), 0), false);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            throw new ItemExistsException("A node with this name (" + destAbsPath + ") is already exists. ");
        }
        if (!srcNode.parent().checkedOut()) {
            throw new VersionException("Parent or source Node or its nearest ancestor is checked-in");
        }
        if (!srcNode.checkLocking()) {
            throw new LockException("Source parent node " + srcNode.getPath() + " is locked ");
        }
        ItemDataMoveVisitor initializer = new ItemDataMoveVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.getWorkspace().getNodeTypeManager(), this.getTransientNodesManager(), true);
        this.getTransientNodesManager().rename((NodeData)srcNode.getData(), initializer);
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.getRootNode().refresh(keepChanges);
    }

    public void registerLifecycleListener(SessionLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void removeLockToken(String lt) {
        this.getLockManager().removeLockToken(this.getId(), lt);
    }

    public void save() throws AccessDeniedException, LockException, ConstraintViolationException, InvalidItemStateException, RepositoryException {
        this.getRootNode().save();
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        NamespaceRegistryImpl nrg = (NamespaceRegistryImpl)this.workspace.getNamespaceRegistry();
        if (!nrg.isUriRegistered(uri)) {
            throw new NamespaceException("The specified uri:" + uri + " is not among " + "those registered in the NamespaceRegistry");
        }
        if (nrg.isPrefixMaped(prefix)) {
            throw new NamespaceException("A prefix '" + prefix + "' is currently already mapped to " + nrg.getURI(prefix) + " URI persistently in the repository NamespaceRegistry " + "and cannot be remapped to a new URI using this method, since this would make any " + "content stored using the old URI unreadable.");
        }
        if (this.namespaces.containsKey(prefix)) {
            throw new NamespaceException("A prefix '" + prefix + "' is currently already mapped to " + this.namespaces.get(prefix) + " URI transiently within this Session and cannot be " + "remapped to a new URI using this method, since this would make any " + "content stored using the old URI unreadable.");
        }
        nrg.validateNamespace(prefix, uri);
        this.namespaces.put(prefix, uri);
        this.prefixes.put(uri, prefix);
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    LocationFactory getSystemLocationFactory() {
        return this.systemLocationFactory;
    }
}

