/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.access;

import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AuthenticationPolicy;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.SecurityService;
import org.exoplatform.services.security.impl.CredentialsImpl;
import org.exoplatform.services.security.jaas.BasicCallbackHandler;

public abstract class BaseAuthenticationPolicy
implements AuthenticationPolicy {
    protected static Log log = ExoLogger.getLogger((String)"jcr.AuthenticationPolicy");
    protected RepositoryEntry config;
    protected SecurityService securityService;

    public BaseAuthenticationPolicy(RepositoryEntry config, SecurityService securityService) {
        this.config = config;
        this.securityService = securityService;
    }

    public final Credentials authenticate(Credentials credentials) throws javax.jcr.LoginException {
        CredentialsImpl thisCredentials;
        if (credentials instanceof CredentialsImpl) {
            thisCredentials = (CredentialsImpl)credentials;
        } else if (credentials instanceof SimpleCredentials) {
            String name = ((SimpleCredentials)credentials).getUserID();
            char[] pswd = ((SimpleCredentials)credentials).getPassword();
            thisCredentials = new CredentialsImpl(name, pswd);
        } else {
            throw new javax.jcr.LoginException("Credentials for the authentication should be CredentialsImpl or SimpleCredentials type");
        }
        this.doAuthentication(thisCredentials);
        log.debug((Object)("Repository.login() authenticated " + thisCredentials.getUserID()));
        return thisCredentials;
    }

    public abstract Credentials authenticate() throws javax.jcr.LoginException;

    private void doAuthentication(CredentialsImpl credentials) throws javax.jcr.LoginException {
        if (credentials.getUserID().equals(SystemIdentity.SYSTEM)) {
            return;
        }
        BasicCallbackHandler handler = new BasicCallbackHandler(credentials.getUserID(), credentials.getPassword());
        try {
            LoginContext loginContext = new LoginContext(this.config.getSecurityDomain(), (CallbackHandler)handler);
            loginContext.login();
        }
        catch (LoginException e) {
            throw new javax.jcr.LoginException("Login failed for " + credentials.getUserID() + " " + e);
        }
        log.debug((Object)("Logged " + credentials.getUserID()));
    }
}

