/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.CommittableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedIndexReader;
import org.exoplatform.services.log.ExoLogger;

abstract class AbstractIndex {
    private static Log log = ExoLogger.getLogger((String)"jcr.AbstractIndex");
    private static final LoggingPrintStream STREAM_LOGGER = new LoggingPrintStream();
    private IndexWriter indexWriter;
    private CommittableIndexReader indexReader;
    private Directory directory;
    private Analyzer analyzer;
    private boolean useCompoundFile = true;
    private int minMergeDocs = 100;
    private int maxMergeDocs = 100000;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private DocNumberCache cache;
    private SharedIndexReader sharedReader;

    AbstractIndex(Analyzer analyzer, Directory directory, DocNumberCache cache) throws IOException {
        this.analyzer = analyzer;
        this.directory = directory;
        this.cache = cache;
        if (!IndexReader.indexExists((Directory)directory)) {
            log.debug((Object)"closing IndexWriter.");
            this.indexWriter = new IndexWriter(directory, analyzer, true);
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    Directory getDirectory() throws IOException {
        return this.directory;
    }

    void addDocument(Document doc) throws IOException {
        this.getIndexWriter().addDocument(doc);
        this.invalidateSharedReader();
    }

    int removeDocument(Term idTerm) throws IOException {
        return this.getIndexReader().delete(idTerm);
    }

    protected synchronized IndexReader getIndexReader() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            log.debug((Object)"closing IndexWriter.");
            this.indexWriter = null;
        }
        if (this.indexReader == null) {
            this.indexReader = new CommittableIndexReader(IndexReader.open((Directory)this.getDirectory()));
        }
        return this.indexReader;
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader() throws IOException {
        IndexReader modifiableReader = this.getIndexReader();
        BitSet deleted = new BitSet(modifiableReader.maxDoc());
        for (int i = 0; i < modifiableReader.maxDoc(); ++i) {
            if (!modifiableReader.isDeleted(i)) continue;
            deleted.set(i);
        }
        if (this.sharedReader == null) {
            CachingIndexReader cr = new CachingIndexReader(IndexReader.open((Directory)this.getDirectory()), this.cache);
            this.sharedReader = new SharedIndexReader(cr);
        }
        return new ReadOnlyIndexReader(this.sharedReader, deleted);
    }

    protected synchronized IndexWriter getIndexWriter() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
            log.debug((Object)"closing IndexReader.");
            this.indexReader = null;
        }
        if (this.indexWriter == null) {
            this.indexWriter = new IndexWriter(this.getDirectory(), this.analyzer, false);
            this.indexWriter.minMergeDocs = this.minMergeDocs;
            this.indexWriter.maxMergeDocs = this.maxMergeDocs;
            this.indexWriter.mergeFactor = this.mergeFactor;
            this.indexWriter.maxFieldLength = this.maxFieldLength;
            this.indexWriter.setUseCompoundFile(this.useCompoundFile);
            this.indexWriter.infoStream = STREAM_LOGGER;
        }
        return this.indexWriter;
    }

    protected void commit() throws IOException {
        this.commit(false);
    }

    protected synchronized void commit(boolean optimize) throws IOException {
        if (!IndexReader.isLocked((Directory)this.getDirectory())) {
            return;
        }
        if (this.indexReader != null) {
            this.indexReader.commitDeleted();
        }
        if (this.indexWriter != null) {
            log.debug((Object)"committing IndexWriter.");
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (optimize) {
            IndexWriter writer = this.getIndexWriter();
            writer.optimize();
            writer.close();
            this.indexWriter = null;
        }
    }

    synchronized void close() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException e) {
                log.warn((Object)("Exception closing index writer: " + e.toString()));
            }
            this.indexWriter = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException e) {
                log.warn((Object)("Exception closing index reader: " + e.toString()));
            }
            this.indexReader = null;
        }
        if (this.sharedReader != null) {
            try {
                this.sharedReader.close();
            }
            catch (IOException e) {
                log.warn((Object)("Exception closing index reader: " + e.toString()));
            }
        }
        if (this.directory != null) {
            try {
                this.directory.close();
            }
            catch (IOException e) {
                this.directory = null;
            }
        }
    }

    protected synchronized void invalidateSharedReader() throws IOException {
        if (this.sharedReader != null) {
            this.sharedReader.close();
            this.sharedReader = null;
        }
    }

    void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
        if (this.indexWriter != null) {
            this.indexWriter.setUseCompoundFile(b);
        }
    }

    void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
        if (this.indexWriter != null) {
            this.indexWriter.minMergeDocs = minMergeDocs;
        }
    }

    void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
        if (this.indexWriter != null) {
            this.indexWriter.maxMergeDocs = maxMergeDocs;
        }
    }

    void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
        if (this.indexWriter != null) {
            this.indexWriter.mergeFactor = mergeFactor;
        }
    }

    void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        if (this.indexWriter != null) {
            this.indexWriter.maxFieldLength = maxFieldLength;
        }
    }

    private static final class LoggingPrintStream
    extends PrintStream {
        private StringBuffer buffer = new StringBuffer();

        public LoggingPrintStream() {
            super(new OutputStream(){

                public void write(int b) {
                }
            });
        }

        public void print(String s) {
            this.buffer.append(s);
        }

        public void println(String s) {
            this.buffer.append(s);
            log.debug((Object)this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

