/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheckError;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;

class ConsistencyCheck {
    private static Log log = ExoLogger.getLogger((String)"jcr.ConsistencyCheck");
    private WorkspacePersistentDataManager dataManager;
    private final MultiIndex index;
    private Map documents;
    private final List errors = new ArrayList();

    private ConsistencyCheck(MultiIndex index, WorkspacePersistentDataManager dataManager) {
        this.index = index;
        this.dataManager = dataManager;
    }

    static ConsistencyCheck run(MultiIndex index, WorkspacePersistentDataManager dataManager) throws IOException, RepositoryException {
        ConsistencyCheck check = new ConsistencyCheck(index, dataManager);
        check.run();
        return check;
    }

    void repair(boolean ignoreFailure) throws IOException {
        if (this.errors.size() == 0) {
            log.info((Object)"No errors found.");
            return;
        }
        int notRepairable = 0;
        for (ConsistencyCheckError error : this.errors) {
            try {
                if (error.repairable()) {
                    error.repair();
                    continue;
                }
                log.warn((Object)("Not repairable: " + error));
                ++notRepairable;
            }
            catch (Exception e2) {
                IOException e2;
                if (ignoreFailure) {
                    e2.printStackTrace();
                    log.warn((Object)("Exception while reparing: " + e2));
                    continue;
                }
                if (!(e2 instanceof IOException)) {
                    e2 = new IOException(e2.getMessage());
                }
                throw (IOException)e2;
            }
        }
        log.info((Object)("Repaired " + (this.errors.size() - notRepairable) + " errors."));
        if (notRepairable > 0) {
            log.warn((Object)("" + notRepairable + " error(s) not repairable."));
        }
    }

    List getErrors() {
        return new ArrayList(this.errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException, RepositoryException {
        String identifier;
        HashSet<String> multipleEntries = new HashSet<String>();
        this.documents = new HashMap();
        IndexReader reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (reader.isDeleted(i)) continue;
                Document d = reader.document(i);
                identifier = d.get(FieldNames.UUID);
                if (this.dataManager.getItemData(identifier) != null) {
                    Document old = this.documents.put(identifier, d);
                    if (old == null) continue;
                    multipleEntries.add(identifier);
                    continue;
                }
                this.errors.add(new NodeDeleted(identifier));
            }
        }
        finally {
            reader.close();
        }
        Iterator<Object> it = multipleEntries.iterator();
        while (it.hasNext()) {
            this.errors.add(new MultipleEntries((String)it.next()));
        }
        for (Document d : this.documents.values()) {
            identifier = d.get(FieldNames.UUID);
            String parentIdentifier = d.get(FieldNames.PARENT);
            if (this.documents.containsKey(parentIdentifier) || parentIdentifier.length() == 0) continue;
            if (this.dataManager.getItemData(identifier) != null) {
                this.errors.add(new MissingAncestor(identifier, parentIdentifier));
                continue;
            }
            this.errors.add(new UnknownParent(identifier, parentIdentifier));
        }
    }

    private class NodeDeleted
    extends ConsistencyCheckError {
        NodeDeleted(String identifier) {
            super("Node " + identifier + " does not longer exist.", identifier);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            log.info((Object)("Removing deleted node from index: " + this.identifier));
            ConsistencyCheck.this.index.removeDocument(new Term(FieldNames.UUID, this.identifier));
        }
    }

    private class MultipleEntries
    extends ConsistencyCheckError {
        MultipleEntries(String identifier) {
            super("Multiple entries found for node " + identifier, identifier);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            Term id = new Term(FieldNames.UUID, this.identifier);
            ConsistencyCheck.this.index.removeAllDocuments(id);
            try {
                NodeData node = (NodeData)ConsistencyCheck.this.dataManager.getItemData(this.identifier);
                log.info((Object)("Re-indexing duplicate node occurrences in index: " + node.getQPath().getAsString()));
                Document d = ConsistencyCheck.this.index.createDocument(node);
                ConsistencyCheck.this.index.addDocument(d);
                ConsistencyCheck.this.documents.put(node.getIdentifier(), d);
            }
            catch (RepositoryException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private class UnknownParent
    extends ConsistencyCheckError {
        private UnknownParent(String identifier, String parentIdentifier) {
            super("Node " + identifier + " has unknown parent: " + parentIdentifier, identifier);
        }

        public boolean repairable() {
            return false;
        }

        public void repair() throws IOException {
            log.warn((Object)("Unknown parent for " + this.identifier + " cannot be repaired"));
        }
    }

    private class MissingAncestor
    extends ConsistencyCheckError {
        private final String parentIdentifier;

        private MissingAncestor(String identifier, String parentIdentifier) {
            super("Parent of " + identifier + " missing in index. Parent: " + parentIdentifier, identifier);
            this.parentIdentifier = parentIdentifier;
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            String pIdentifier = this.parentIdentifier;
            while (pIdentifier != null && !ConsistencyCheck.this.documents.containsKey(pIdentifier)) {
                try {
                    NodeData n = (NodeData)ConsistencyCheck.this.dataManager.getItemData(pIdentifier);
                    if (n != null) {
                        log.info((Object)("Reparing missing node " + n.getQPath().getAsString()));
                        Document d = ConsistencyCheck.this.index.createDocument(n);
                        ConsistencyCheck.this.index.addDocument(d);
                        ConsistencyCheck.this.documents.put(n.getIdentifier(), d);
                        pIdentifier = n.getParentIdentifier();
                        continue;
                    }
                    pIdentifier = null;
                }
                catch (RepositoryException e) {
                    throw new IOException(e.toString());
                }
            }
        }
    }
}

