/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.log.ExoLogger;

@Deprecated
class DocOrderNodeIteratorImpl
implements ScoreNodeIterator {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocOrderNodeIteratorImpl");
    private NodeIteratorImpl orderedNodes;
    protected String[] identifiers;
    protected Float[] scores;
    protected final SessionDataManager itemMgr;

    DocOrderNodeIteratorImpl(SessionDataManager itemMgr, String[] identifiers, Float[] scores) {
        this.itemMgr = itemMgr;
        this.identifiers = identifiers;
        this.scores = scores;
    }

    public Object next() {
        return this.nextNodeImpl();
    }

    public Node nextNode() {
        return this.nextNodeImpl();
    }

    public NodeImpl nextNodeImpl() {
        this.initOrderedIterator();
        return this.orderedNodes.nextNodeImpl();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skip(skipNum);
    }

    public long getSize() {
        if (this.orderedNodes != null) {
            return this.orderedNodes.getSize();
        }
        return this.identifiers.length;
    }

    public long getPosition() {
        this.initOrderedIterator();
        return this.orderedNodes.getPosition();
    }

    public boolean hasNext() {
        this.initOrderedIterator();
        return this.orderedNodes.hasNext();
    }

    public float getScore() {
        this.initOrderedIterator();
        return this.orderedNodes.getScore();
    }

    private void initOrderedIterator() {
        if (this.orderedNodes != null) {
            return;
        }
        long time = System.currentTimeMillis();
        ScoreNode[] nodes = new ScoreNode[this.identifiers.length];
        for (int i = 0; i < this.identifiers.length; ++i) {
            nodes[i] = new ScoreNode(this.identifiers[i], this.scores[i]);
        }
        final ArrayList invalidIdentifiers = new ArrayList(2);
        do {
            if (invalidIdentifiers.size() > 0) {
                ScoreNode[] tmp = new ScoreNode[nodes.length - invalidIdentifiers.size()];
                int newIdx = 0;
                for (int i = 0; i < nodes.length; ++i) {
                    if (invalidIdentifiers.contains(nodes[i].identifier)) continue;
                    tmp[newIdx++] = nodes[i];
                }
                nodes = tmp;
                invalidIdentifiers.clear();
            }
            try {
                Arrays.sort(nodes, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ScoreNode n1 = (ScoreNode)o1;
                        ScoreNode n2 = (ScoreNode)o2;
                        try {
                            int commonDepth;
                            NodeImpl node2;
                            NodeImpl node1;
                            try {
                                node1 = (NodeImpl)DocOrderNodeIteratorImpl.this.itemMgr.getItemByIdentifier(n1.identifier, false);
                                if (node1 == null) {
                                    throw new RepositoryException("Node not found for " + n1.identifier);
                                }
                            }
                            catch (RepositoryException e) {
                                invalidIdentifiers.add(n1.identifier);
                                throw new SortFailedException();
                            }
                            try {
                                node2 = (NodeImpl)DocOrderNodeIteratorImpl.this.itemMgr.getItemByIdentifier(n2.identifier, false);
                                if (node2 == null) {
                                    throw new RepositoryException("Node not found for " + n2.identifier);
                                }
                            }
                            catch (RepositoryException e) {
                                invalidIdentifiers.add(n2.identifier);
                                throw new SortFailedException();
                            }
                            QPathEntry[] path1 = node1.getLocation().getInternalPath().getEntries();
                            QPathEntry[] path2 = node2.getLocation().getInternalPath().getEntries();
                            for (commonDepth = 0; path1.length > commonDepth && path2.length > commonDepth && path1[commonDepth].equals(path2[commonDepth]); ++commonDepth) {
                            }
                            if (path1.length - 1 == --commonDepth) {
                                return -1;
                            }
                            if (path2.length - 1 == commonDepth) {
                                return 1;
                            }
                            NodeImpl commonNode = (NodeImpl)node1.getAncestor(commonDepth);
                            node1 = (NodeImpl)node1.getAncestor(commonDepth + 1);
                            node2 = (NodeImpl)node2.getAncestor(commonDepth + 1);
                            NodeIterator it = commonNode.getNodes();
                            while (it.hasNext()) {
                                Node child = it.nextNode();
                                if (child.isSame((Item)node1)) {
                                    return -1;
                                }
                                if (!child.isSame((Item)node2)) continue;
                                return 1;
                            }
                            log.error((Object)"Internal error: unable to determine document order of nodes:");
                            log.error((Object)("\tNode1: " + node1.getPath()));
                            log.error((Object)("\tNode2: " + node2.getPath()));
                        }
                        catch (RepositoryException e) {
                            log.error((Object)("Exception while sorting nodes in document order: " + e.toString()), (Throwable)e);
                        }
                        invalidIdentifiers.add(n1.identifier);
                        invalidIdentifiers.add(n2.identifier);
                        throw new SortFailedException();
                    }
                });
            }
            catch (SortFailedException e) {
                // empty catch block
            }
        } while (invalidIdentifiers.size() > 0);
        if (this.identifiers.length != nodes.length) {
            this.identifiers = new String[nodes.length];
            this.scores = new Float[nodes.length];
        }
        for (int i = 0; i < nodes.length; ++i) {
            this.identifiers[i] = nodes[i].identifier;
            this.scores[i] = nodes[i].score;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + this.identifiers.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms"));
        }
        this.orderedNodes = new NodeIteratorImpl(this.itemMgr, this.identifiers, this.scores);
    }

    private static final class SortFailedException
    extends RuntimeException {
        private SortFailedException() {
        }
    }

    private static final class ScoreNode {
        final String identifier;
        final Float score;

        ScoreNode(String identifier, Float score) {
            this.identifier = identifier;
            this.score = score;
        }
    }
}

