/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.WildcardTermEnum;
import org.exoplatform.services.log.ExoLogger;

public class WildcardQuery
extends Query {
    private static Log log = ExoLogger.getLogger((String)"jcr.WildcardQuery");
    private final String field;
    private final String propName;
    private final String pattern;
    private static final Map cache = new WeakHashMap();

    public WildcardQuery(String field, String propName, String pattern) {
        this.field = field;
        this.propName = propName;
        this.pattern = pattern;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        MultiTermQuery stdWildcardQuery = new MultiTermQuery(new Term(FieldNames.PROPERTIES, this.pattern)){

            protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
                return new WildcardTermEnum(reader, WildcardQuery.this.field, WildcardQuery.this.propName, WildcardQuery.this.pattern);
            }
        };
        try {
            return stdWildcardQuery.rewrite(reader);
        }
        catch (BooleanQuery.TooManyClauses e) {
            log.debug((Object)"Too many terms to enumerate, using custom WildcardQuery.");
            return this;
        }
    }

    protected Weight createWeight(Searcher searcher) {
        return new WildcardQueryWeight(searcher);
    }

    public String toString(String field) {
        return this.propName + ":" + this.pattern;
    }

    private final class WildcardQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private boolean hitsCalculated;
        private int nextDoc;
        private final String cacheKey;
        private final Map resultMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WildcardQueryScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.hitsCalculated = false;
            this.nextDoc = -1;
            this.reader = reader;
            this.cacheKey = WildcardQuery.this.field + '\uffff' + WildcardQuery.this.propName + '\uffff' + WildcardQuery.this.pattern;
            Map map = cache;
            synchronized (map) {
                Map m = (Map)cache.get(reader);
                if (m == null) {
                    m = new LRUMap(10);
                    cache.put(reader, m);
                }
                this.resultMap = m;
            }
            map = this.resultMap;
            synchronized (map) {
                BitSet result = (BitSet)this.resultMap.get(this.cacheKey);
                if (result == null) {
                    result = new BitSet(reader.maxDoc());
                } else {
                    this.hitsCalculated = true;
                }
                this.hits = result;
            }
        }

        public boolean next() throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() {
            return 1.0f;
        }

        public boolean skipTo(int target) {
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) {
            return new Explanation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateHits() throws IOException {
            if (this.hitsCalculated) {
                return;
            }
            WildcardTermEnum terms = new WildcardTermEnum(this.reader, WildcardQuery.this.field, WildcardQuery.this.propName, WildcardQuery.this.pattern);
            try {
                TermDocs docs = this.reader.termDocs();
                try {
                    while (terms.term() != null) {
                        docs.seek((TermEnum)terms);
                        while (docs.next()) {
                            this.hits.set(docs.doc());
                        }
                        if (terms.next()) continue;
                        break;
                    }
                }
                finally {
                    docs.close();
                }
            }
            finally {
                terms.close();
            }
            this.hitsCalculated = true;
            Map map = this.resultMap;
            synchronized (map) {
                this.resultMap.put(this.cacheKey, this.hits);
            }
        }
    }

    private class WildcardQueryWeight
    implements Weight {
        private final Searcher searcher;

        public WildcardQueryWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return WildcardQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new WildcardQueryScorer(this.searcher.getSimilarity(), reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

