/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.value.ExtendedValue;
import org.exoplatform.services.jcr.core.value.ReadableBinaryValue;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;

public abstract class BaseValue
implements ExtendedValue,
ReadableBinaryValue {
    protected static Log log = ExoLogger.getLogger((String)"jcr.BinaryValue");
    protected final int type;
    protected LocalTransientValueData data;
    protected TransientValueData internalData;

    BaseValue(int type, TransientValueData data) throws IOException {
        this.type = type;
        this.internalData = data;
    }

    protected LocalTransientValueData getLocalData(boolean asStream) throws IOException {
        if (this.data == null) {
            this.data = new LocalTransientValueData(asStream);
        }
        return this.data;
    }

    protected String getInternalString() throws ValueFormatException, RepositoryException {
        try {
            return new String(this.getLocalData(false).getAsByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
        }
        catch (IOException e) {
            throw new ValueFormatException("conversion to string failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Calendar getInternalCalendar() throws ValueFormatException, RepositoryException {
        try {
            if (this.type == 5) {
                return new JCRDateFormat().deserialize(new String(this.getLocalData(false).getAsByteArray(), "UTF-8"));
            }
            return JCRDateFormat.parse(new String(this.getLocalData(false).getAsByteArray(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
        }
        catch (IOException e) {
            throw new ValueFormatException("conversion to date failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public final int getType() {
        return this.type;
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        Calendar cal = this.getInternalCalendar();
        if (cal == null) {
            throw new ValueFormatException("not a valid date format " + this.getInternalString());
        }
        return cal;
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        try {
            return Long.parseLong(this.getInternalString());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("conversion to long failed", (Throwable)e);
        }
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        return Boolean.valueOf(this.getInternalString());
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        try {
            return Double.parseDouble(this.getInternalString());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("conversion to double failed", (Throwable)e);
        }
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        try {
            return this.getLocalData(true).getAsStream();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getInternalString();
    }

    public String getReference() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("Can not convert " + PropertyType.nameFromValue((int)this.type) + " to Reference");
    }

    public TransientValueData getInternalData() {
        return this.internalData;
    }

    public long getLength() {
        try {
            return this.getLocalData(this.type == 2).getLength();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        if (obj instanceof BaseValue) {
            BaseValue other = (BaseValue)obj;
            return this.getInternalData().equals(other.getInternalData());
        }
        return false;
    }

    public int getOrderNumber() {
        try {
            return this.getLocalData(this.type == 2).getOrderNumber();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setOrderNumber(int order) {
        try {
            this.getLocalData(this.type == 2).setOrderNumber(order);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long read(OutputStream stream, long length, long position) throws IOException, RepositoryException {
        return this.getInternalData().read(stream, length, position);
    }

    protected class LocalTransientValueData
    extends AbstractValueData {
        protected InputStream stream;
        protected byte[] bytes;
        protected final long length;

        public LocalTransientValueData(boolean asStream) throws IOException {
            super(BaseValue.this.getInternalData().getOrderNumber());
            TransientValueData idata = BaseValue.this.getInternalData();
            if (!asStream) {
                this.bytes = idata.getAsByteArray();
                this.stream = null;
            } else {
                this.stream = idata.getAsStream();
                this.bytes = null;
            }
            this.length = idata.getLength();
        }

        public byte[] getAsByteArray() throws IllegalStateException, IOException {
            if (this.streamConsumed()) {
                throw new IllegalStateException("stream value has already been consumed");
            }
            return this.bytes;
        }

        public InputStream getAsStream() throws IOException, IllegalStateException {
            if (this.bytesConsumed()) {
                throw new IllegalStateException("non-stream value has already been consumed");
            }
            return this.stream;
        }

        public long getLength() {
            return this.length;
        }

        public boolean isByteArray() {
            return this.bytes != null;
        }

        private boolean streamConsumed() {
            return this.stream != null;
        }

        private boolean bytesConsumed() {
            return this.bytes != null;
        }

        public TransientValueData createTransientCopy() {
            throw new RuntimeException("LocalTransientValueData.createTransientCopy()");
        }
    }
}

