/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FileStreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;

public abstract class FileIOChannel
implements ValueIOChannel {
    private static Log log = ExoLogger.getLogger((String)"jcr.FileIOChannel");
    public static final int IOBUFFER_SIZE = 32768;
    protected final File rootDir;
    protected final FileCleaner cleaner;
    protected String storageId;

    public FileIOChannel(File rootDir, FileCleaner cleaner, String storageId) {
        this.rootDir = rootDir;
        this.cleaner = cleaner;
        this.storageId = storageId;
    }

    public boolean delete(String propertyId) throws IOException {
        File[] valueFiles = this.getFiles(propertyId);
        boolean result = true;
        for (File valueFile : valueFiles) {
            if (valueFile.delete()) continue;
            result = false;
            this.cleaner.addFile(valueFile);
        }
        return result;
    }

    public void close() {
    }

    public ValueData read(String propertyId, int orderNumber, int maxBufferSize) throws IOException {
        File valueFile = this.getFile(propertyId, orderNumber);
        return this.readValue(valueFile, orderNumber, maxBufferSize, false);
    }

    public void write(String propertyId, ValueData value) throws IOException {
        File file = this.getFile(propertyId, value.getOrderNumber());
        this.writeValue(file, value);
    }

    protected abstract File getFile(String var1, int var2);

    protected abstract File[] getFiles(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData readValue(File file, int orderNum, int maxBufferSize, boolean temp) throws IOException {
        FileInputStream is = new FileInputStream(file);
        FileChannel channel = is.getChannel();
        try {
            int size = (int)channel.size();
            if (size > maxBufferSize) {
                FileStreamPersistedValueData fileStreamPersistedValueData = new FileStreamPersistedValueData(file, orderNum, temp);
                return fileStreamPersistedValueData;
            }
            ByteBuffer buf = ByteBuffer.allocate(size);
            int numRead = channel.read(buf);
            byte[] arr = new byte[numRead];
            buf.rewind();
            buf.get(arr);
            ByteArrayPersistedValueData byteArrayPersistedValueData = new ByteArrayPersistedValueData(arr, orderNum);
            return byteArrayPersistedValueData;
        }
        finally {
            channel.close();
            is.close();
        }
    }

    protected void writeValue(File file, ValueData value) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        if (value.isByteArray()) {
            byte[] buff = value.getAsByteArray();
            out.write(buff);
        } else {
            int len;
            byte[] buffer = new byte[32768];
            InputStream in = value.getAsStream();
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        out.close();
    }

    public String getStorageId() {
        return this.storageId;
    }
}

