/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.xml.XmlMapping;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.DocumentViewContentExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.DocumentViewStreamExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.SystemViewContentExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.SystemViewStreamExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.WorkspaceSystemViewStreamExporter;
import org.exoplatform.services.jcr.impl.xml.importing.ContentHandlerImporter;
import org.exoplatform.services.jcr.impl.xml.importing.StreamImporter;
import org.exoplatform.services.jcr.impl.xml.importing.WorkspaceDataImporter;
import org.xml.sax.ContentHandler;

public class ExportImportFactory {
    private final SessionImpl sessionImpl;

    public ExportImportFactory(SessionImpl sessionImpl) {
        this.sessionImpl = sessionImpl;
    }

    public BaseXmlExporter getExportVisitor(XmlMapping type, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        if (type == XmlMapping.SYSVIEW) {
            return new SystemViewContentExporter(contentHandler, this.sessionImpl, this.sessionImpl.getTransientNodesManager(), skipBinary, noRecurse);
        }
        if (type == XmlMapping.DOCVIEW) {
            return new DocumentViewContentExporter(contentHandler, this.sessionImpl, this.sessionImpl.getTransientNodesManager(), skipBinary, noRecurse);
        }
        return null;
    }

    public BaseXmlExporter getExportVisitor(XmlMapping type, OutputStream stream, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException, IOException {
        XMLStreamWriter streamWriter;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            streamWriter = outputFactory.createXMLStreamWriter(stream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        if (type == XmlMapping.SYSVIEW) {
            return new SystemViewStreamExporter(streamWriter, this.sessionImpl, this.sessionImpl.getTransientNodesManager(), skipBinary, noRecurse);
        }
        if (type == XmlMapping.DOCVIEW) {
            return new DocumentViewStreamExporter(streamWriter, this.sessionImpl, this.sessionImpl.getTransientNodesManager(), skipBinary, noRecurse);
        }
        if (type == XmlMapping.BACKUP) {
            return new WorkspaceSystemViewStreamExporter(streamWriter, this.sessionImpl, this.sessionImpl.getTransientNodesManager(), skipBinary, noRecurse);
        }
        return null;
    }

    public ContentHandler getImportHandler(NodeImpl node, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        return new ContentHandlerImporter(node, uuidBehavior, saveType, context);
    }

    public StreamImporter getStreamImporter(NodeImpl node, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        return new StreamImporter(node, uuidBehavior, saveType, context);
    }

    public StreamImporter getWorkspaceImporter(InvocationContext context) {
        return new WorkspaceDataImporter(context);
    }
}

