/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class HandlingContentExporter
extends BaseXmlExporter {
    protected final ContentHandler contentHandler;

    public HandlingContentExporter(ContentHandler handler, SessionImpl session, ItemDataConsumer dataManager, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(session, dataManager, skipBinary, noRecurse ? 1 : -1);
        this.contentHandler = handler;
        this.setNoRecurse(noRecurse);
    }

    public void export(NodeData node) throws RepositoryException, SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
            this.startPrefixMapping();
            node.accept(this);
            this.endPrefixMapping();
            this.contentHandler.endDocument();
        }
    }

    protected void endPrefixMapping() throws RepositoryException, SAXException {
        String[] prefixes;
        for (String prefix : prefixes = this.session.getNamespacePrefixes()) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    protected void startPrefixMapping() throws RepositoryException, SAXException {
        String[] prefixes;
        for (String prefix : prefixes = this.namespaceRegistry.getPrefixes()) {
            if (prefix == null || prefix.length() < 1 || prefix.equals("xml")) continue;
            this.contentHandler.startPrefixMapping(prefix, this.session.getNamespaceURI(prefix));
        }
    }
}

