/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;

public abstract class StreamExporter
extends BaseXmlExporter {
    protected final XMLStreamWriter writer;

    public StreamExporter(XMLStreamWriter writer, SessionImpl session, ItemDataConsumer dataManager, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(session, dataManager, skipBinary, noRecurse ? 1 : -1);
        this.writer = writer;
        this.setNoRecurse(noRecurse);
    }

    public void export(NodeData node) throws RepositoryException, XMLStreamException {
        if (this.writer != null) {
            this.writer.writeStartDocument("UTF-8", "1.0");
            node.accept(this);
            this.writer.writeEndDocument();
            this.writer.close();
        }
    }

    protected void startPrefixMapping() throws RepositoryException, XMLStreamException {
        String[] prefixes;
        for (String prefix : prefixes = this.namespaceRegistry.getPrefixes()) {
            if (prefix == null || prefix.length() < 1 || prefix.equals("xml")) continue;
            this.writer.writeNamespace(prefix, this.namespaceRegistry.getURI(prefix));
        }
    }
}

