/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.importing.ContentImporter;
import org.exoplatform.services.jcr.impl.xml.importing.NeutralImporter;
import org.exoplatform.services.jcr.impl.xml.importing.RawDataImporter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ContentHandlerImporter
implements ContentHandler,
ErrorHandler,
RawDataImporter {
    private ContentImporter importer;
    private final NodeImpl parent;
    private final XmlSaveType saveType;
    private final int uuidBehavior;
    private final InvocationContext context;

    public ContentHandlerImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        this.saveType = saveType;
        this.uuidBehavior = uuidBehavior;
        this.parent = parent;
        this.context = context;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.importer.characters(ch, start, length);
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public ContentImporter createContentImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        return new NeutralImporter(parent, uuidBehavior, saveType, context);
    }

    public void endDocument() throws SAXException {
        try {
            this.importer.save();
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.importer.endElement(uri, localName, qName);
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void endPrefixMapping(String arg0) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    public void setDocumentLocator(Locator arg0) {
    }

    public void skippedEntity(String arg0) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.importer = this.createContentImporter(this.parent, this.uuidBehavior, this.saveType, this.context);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            HashMap<String, String> attribute = new HashMap<String, String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                attribute.put(atts.getQName(i), atts.getValue(i));
            }
            this.importer.startElement(uri, localName, qName, attribute);
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.importer.registerNamespace(prefix, uri);
    }

    public void warning(SAXParseException exception) throws SAXException {
    }
}

