/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.xml.DecodedValue;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.importing.BaseXmlImporter;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportItemData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportPropertyData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.PropertyInfo;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemViewImporter
extends BaseXmlImporter {
    private static Log log = ExoLogger.getLogger(SystemViewImporter.class);
    protected PropertyInfo propertyInfo = new PropertyInfo();
    protected String ROOT_NODE_NAME = "jcr:root";

    public SystemViewImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        super(parent, uuidBehavior, saveType, context);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws RepositoryException {
        if (this.propertyInfo.getValues().size() > 0) {
            DecodedValue curPropValue = this.propertyInfo.getValues().get(this.propertyInfo.getValues().size() - 1);
            if (this.propertyInfo.getType() == 2) {
                try {
                    curPropValue.getBinaryDecoder().write(ch, start, length);
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            } else {
                curPropValue.getStringBuffer().append(ch, start, length);
            }
        } else {
            log.warn((Object)("Wrong XML content. Element 'sv:value' expected, but SAX event 'characters' occured. characters:[" + new String(ch, start, length) + "]"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws RepositoryException {
        InternalQName elementName = this.locationFactory.parseJCRName(name).getInternalName();
        if (Constants.SV_NODE_NAME.equals((Object)elementName)) {
            this.endNode();
        } else if (Constants.SV_PROPERTY_NAME.equals((Object)elementName)) {
            ImportPropertyData propertyData = this.endProperty();
            if (propertyData != null) {
                this.changesLog.add(new ItemState(propertyData, 1, true, this.getParent().getQPath()));
            }
        } else if (!Constants.SV_VALUE_NAME.equals((Object)elementName)) {
            throw new RepositoryException("invalid element in system view xml document: " + localName);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String name, Map<String, String> atts) throws RepositoryException {
        InternalQName elementName = this.locationFactory.parseJCRName(name).getInternalName();
        if (Constants.SV_NODE_NAME.equals((Object)elementName)) {
            String svName = this.getAttribute(atts, Constants.SV_NAME_NAME);
            if (svName == null) {
                throw new RepositoryException("Missing mandatory sv:name attribute of element sv:node");
            }
            NodeData parentData = null;
            parentData = this.getParent();
            InternalQName currentNodeName = null;
            currentNodeName = this.ROOT_NODE_NAME.equals(svName) ? Constants.ROOT_PATH.getName() : this.locationFactory.parseJCRName(svName).getInternalName();
            int nodeIndex = this.getNodeIndex(parentData, currentNodeName, null);
            ImportNodeData newNodeData = new ImportNodeData(parentData, currentNodeName, nodeIndex);
            newNodeData.setOrderNumber(this.getNextChildOrderNum(parentData));
            newNodeData.setIdentifier(IdGenerator.generate());
            this.changesLog.add(new ItemState(newNodeData, 1, true, parentData.getQPath()));
            this.tree.push(newNodeData);
        } else if (Constants.SV_PROPERTY_NAME.equals((Object)elementName)) {
            this.propertyInfo.setValues(new ArrayList<DecodedValue>());
            String svName = this.getAttribute(atts, Constants.SV_NAME_NAME);
            if (svName == null) {
                throw new RepositoryException("missing mandatory sv:name attribute of element sv:property");
            }
            this.propertyInfo.setName(this.locationFactory.parseJCRName(svName).getInternalName());
            this.propertyInfo.setIndentifer(IdGenerator.generate());
            String type = this.getAttribute(atts, Constants.SV_TYPE_NAME);
            if (type == null) {
                throw new RepositoryException("missing mandatory sv:type attribute of element sv:property");
            }
            try {
                this.propertyInfo.setType(ExtendedPropertyType.valueFromName(type));
            }
            catch (IllegalArgumentException e) {
                throw new RepositoryException("Unknown property type: " + type, (Throwable)e);
            }
        } else if (Constants.SV_VALUE_NAME.equals((Object)elementName)) {
            this.propertyInfo.getValues().add(new DecodedValue());
        } else {
            throw new RepositoryException("Unknown element " + elementName.getAsString());
        }
    }

    private ImportPropertyData endMixinTypes() throws PathNotFoundException, RepositoryException, NoSuchNodeTypeException {
        InternalQName[] mixinNames = new InternalQName[this.propertyInfo.getValuesSize()];
        ArrayList<TransientValueData> values = new ArrayList<TransientValueData>(this.propertyInfo.getValuesSize());
        ImportNodeData currentNodeInfo = (ImportNodeData)this.getParent();
        for (int i = 0; i < this.propertyInfo.getValuesSize(); ++i) {
            String value = this.propertyInfo.getValues().get(i).toString();
            mixinNames[i] = this.locationFactory.parseJCRName(value).getInternalName();
            currentNodeInfo.addNodeType(this.ntManager.getNodeType(mixinNames[i]));
            values.add(new TransientValueData(value.toString()));
        }
        currentNodeInfo.setMixinTypeNames(mixinNames);
        ImportPropertyData propertyData = new ImportPropertyData(QPath.makeChildPath(currentNodeInfo.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), currentNodeInfo.getIdentifier(), true);
        propertyData.setValues(this.parseValues());
        return propertyData;
    }

    private void endNode() throws RepositoryException {
        ImportNodeData currentNodeInfo = (ImportNodeData)this.tree.pop();
        currentNodeInfo.setMixinTypeNames(currentNodeInfo.getMixinTypeNames());
        if (currentNodeInfo.isMixVersionable() && !currentNodeInfo.isContainsVersionhistory()) {
            PlainChangesLogImpl changes = new PlainChangesLogImpl();
            new VersionHistoryDataHelper(currentNodeInfo, changes, this.session.getTransientNodesManager(), this.session.getWorkspace().getNodeTypeManager(), currentNodeInfo.getVersionHistoryIdentifier(), currentNodeInfo.getBaseVersionIdentifier());
            for (ItemState state : changes.getAllStates()) {
                if (!state.getData().getQPath().isDescendantOf(Constants.JCR_SYSTEM_PATH, false)) continue;
                this.changesLog.add(state);
            }
        }
    }

    private ImportPropertyData endPrimaryType() throws PathNotFoundException, RepositoryException, NoSuchNodeTypeException {
        NodeData parentNodeData;
        String sName = this.propertyInfo.getValues().get(0).toString();
        InternalQName primaryTypeName = this.locationFactory.parseJCRName(sName).getInternalName();
        ImportNodeData nodeData = (ImportNodeData)this.tree.pop();
        if (!"00exo0jcr0root0uuid0000000000000".equals(nodeData.getIdentifier()) && !this.isChildNodePrimaryTypeAllowed((parentNodeData = this.getParent()).getPrimaryTypeName(), parentNodeData.getMixinTypeNames(), sName)) {
            throw new ConstraintViolationException("Can't add node " + nodeData.getQName().getAsString() + " to " + parentNodeData.getQPath().getAsString() + " node type " + sName + " is not allowed as child's node type for parent node type " + parentNodeData.getPrimaryTypeName().getAsString());
        }
        nodeData.addNodeType(this.ntManager.getNodeType(primaryTypeName));
        nodeData.setPrimaryTypeName(primaryTypeName);
        ImportPropertyData propertyData = new ImportPropertyData(QPath.makeChildPath(nodeData.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), nodeData.getIdentifier(), false);
        propertyData.setValues(this.parseValues());
        this.tree.push(nodeData);
        return propertyData;
    }

    private ImportPropertyData endProperty() throws PathNotFoundException, RepositoryException, NoSuchNodeTypeException, IllegalPathException, ValueFormatException {
        ImportPropertyData propertyData = null;
        if (Constants.JCR_PRIMARYTYPE.equals((Object)this.propertyInfo.getName())) {
            propertyData = this.endPrimaryType();
        } else if (Constants.JCR_MIXINTYPES.equals((Object)this.propertyInfo.getName())) {
            propertyData = this.endMixinTypes();
        } else if (Constants.JCR_UUID.equals((Object)this.propertyInfo.getName())) {
            propertyData = this.endUuid();
        } else {
            PropertyDefinitions defs;
            ImportNodeData currentNodeInfo = (ImportNodeData)this.getParent();
            List<ValueData> values = this.parseValues();
            boolean isMultivalue = true;
            try {
                defs = this.ntManager.findPropertyDefinitions(this.propertyInfo.getName(), currentNodeInfo.getPrimaryTypeName(), currentNodeInfo.getMixinTypeNames());
            }
            catch (RepositoryException e) {
                if (!this.context.getBoolean("respectPropertyDefinitionsConstraints")) {
                    log.warn((Object)e.getLocalizedMessage());
                    return null;
                }
                throw e;
            }
            if (values.size() == 1) {
                if (defs.getDefinition(false) != null) {
                    isMultivalue = false;
                }
            } else if (defs.getDefinition(true) == null && defs.getDefinition(false) != null) {
                throw new ValueFormatException("Can not assign multiple-values Value to a single-valued property " + this.propertyInfo.getName().getName());
            }
            log.debug((Object)("Import " + this.propertyInfo.getName().getName() + " size=" + this.propertyInfo.getValuesSize() + " isMultivalue=" + isMultivalue));
            propertyData = new ImportPropertyData(QPath.makeChildPath(currentNodeInfo.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), currentNodeInfo.getIdentifier(), isMultivalue);
            propertyData.setValues(values);
            if (currentNodeInfo.isMixVersionable()) {
                this.endVersionable(currentNodeInfo, values);
            }
        }
        return propertyData;
    }

    private ImportPropertyData endUuid() throws RepositoryException, PathNotFoundException, IllegalPathException {
        ImportNodeData currentNodeInfo = (ImportNodeData)this.tree.pop();
        currentNodeInfo.setMixReferenceable(this.isNodeType(Constants.MIX_REFERENCEABLE, currentNodeInfo.getCurrentNodeTypes()));
        String identifier = null;
        if (currentNodeInfo.isMixReferenceable()) {
            currentNodeInfo.setMixVersionable(this.isNodeType(Constants.MIX_VERSIONABLE, currentNodeInfo.getCurrentNodeTypes()));
            identifier = this.validateUuidCollision(this.propertyInfo.getValues().get(0).toString());
            if (identifier != null) {
                boolean reloadSNS = this.uuidBehavior == 1 || this.uuidBehavior == 2;
                QPath newPath = null;
                if (reloadSNS) {
                    NodeData currentParentData = this.getParent();
                    int nodeIndex = this.getNodeIndex(currentParentData, currentNodeInfo.getQName(), currentNodeInfo.getIdentifier());
                    newPath = QPath.makeChildPath(currentParentData.getQPath(), currentNodeInfo.getQName(), nodeIndex);
                    currentNodeInfo.setQPath(newPath);
                }
                String oldIdentifer = currentNodeInfo.getIdentifier();
                for (ItemState state : this.changesLog.getAllStates()) {
                    ItemData data = state.getData();
                    if (!data.getParentIdentifier().equals(oldIdentifer)) continue;
                    ((ImportItemData)((Object)data)).setParentIdentifer(identifier);
                    if (!reloadSNS) continue;
                    ((ImportItemData)((Object)data)).setQPath(QPath.makeChildPath(newPath, data.getQPath().getName()));
                }
                currentNodeInfo.setIdentifier(identifier);
            }
            if (this.uuidBehavior == 2) {
                currentNodeInfo.setParentIdentifer(this.getParent().getIdentifier());
            }
        }
        ImportPropertyData propertyData = new ImportPropertyData(QPath.makeChildPath(currentNodeInfo.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), currentNodeInfo.getIdentifier(), false);
        propertyData.setValue(new TransientValueData(currentNodeInfo.getIdentifier()));
        this.tree.push(currentNodeInfo);
        return propertyData;
    }

    private void endVersionable(ImportNodeData currentNodeInfo, List<ValueData> values) throws RepositoryException {
        if (this.propertyInfo.getName().equals((Object)Constants.JCR_VERSIONHISTORY)) {
            String versionHistoryIdentifier = null;
            try {
                versionHistoryIdentifier = ((TransientValueData)values.get(0)).getString();
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            currentNodeInfo.setVersionHistoryIdentifier(versionHistoryIdentifier);
            currentNodeInfo.setContainsVersionhistory(this.session.getTransientNodesManager().getItemData(versionHistoryIdentifier) != null);
        } else if (this.propertyInfo.getName().equals((Object)Constants.JCR_BASEVERSION)) {
            try {
                currentNodeInfo.setBaseVersionIdentifier(((TransientValueData)values.get(0)).getString());
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private List<ValueData> parseValues() throws RepositoryException {
        ArrayList<ValueData> values = new ArrayList<ValueData>(this.propertyInfo.getValuesSize());
        for (int k = 0; k < this.propertyInfo.getValuesSize(); ++k) {
            if (this.propertyInfo.getType() == 2) {
                try {
                    InputStream vStream = this.propertyInfo.getValues().get(k).getInputStream();
                    TransientValueData binaryValue = new TransientValueData(vStream);
                    binaryValue.setMaxBufferSize(this.session.getValueFactory().getMaxBufferSize());
                    binaryValue.setFileCleaner(this.session.getValueFactory().getFileCleaner());
                    binaryValue.getAsStream();
                    vStream.close();
                    this.propertyInfo.getValues().get(k).remove();
                    values.add(binaryValue);
                    continue;
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            String val = new String(this.propertyInfo.getValues().get(k).toString());
            values.add(((BaseValue)this.session.getValueFactory().createValue(val, this.propertyInfo.getType())).getInternalData());
        }
        return values;
    }

    protected String getAttribute(Map<String, String> attributes, InternalQName name) throws RepositoryException {
        JCRName jname = this.locationFactory.createJCRName(name);
        return attributes.get(jname.getAsString());
    }
}

