/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.proppatch;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.webdav.WebDavStatus;
import org.exoplatform.services.jcr.webdav.resource.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.transformer.SerializableEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropPatchResponseEntity
implements SerializableEntity {
    private final WebDavNamespaceContext nsContext;
    private Node node;
    private final URI uri;
    private final List<HierarchicalProperty> setList;
    private final List<HierarchicalProperty> removeList;

    public PropPatchResponseEntity(WebDavNamespaceContext nsContext, Node node, URI uri, List<HierarchicalProperty> setList, List<HierarchicalProperty> removeList) {
        this.nsContext = nsContext;
        this.node = node;
        this.uri = uri;
        this.setList = setList;
        this.removeList = removeList;
    }

    public void writeObject(OutputStream outStream) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outStream, "UTF-8");
            xmlStreamWriter.setNamespaceContext(this.nsContext);
            xmlStreamWriter.setDefaultNamespace("DAV:");
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            xmlStreamWriter.writeStartElement("DAV:", "response");
            xmlStreamWriter.writeStartElement("DAV:", "href");
            xmlStreamWriter.writeCharacters(this.uri.toASCIIString());
            xmlStreamWriter.writeEndElement();
            Map<String, Set<HierarchicalProperty>> propStats = this.getPropStat();
            PropertyWriteUtil.writePropStats(xmlStreamWriter, propStats);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException exc) {
            throw new IOException(exc.getMessage());
        }
    }

    protected Map<String, Set<HierarchicalProperty>> getPropStat() {
        Set propSet;
        String statname;
        String propertyName;
        int i;
        HashMap<String, Set<HierarchicalProperty>> propStats = new HashMap<String, Set<HierarchicalProperty>>();
        for (i = 0; i < this.setList.size(); ++i) {
            HierarchicalProperty setProperty = this.setList.get(i);
            try {
                propertyName = WebDavNamespaceContext.createName(setProperty.getName());
                try {
                    this.node.setProperty(propertyName, setProperty.getValue());
                }
                catch (RepositoryException exc) {
                    String[] value = new String[]{setProperty.getValue()};
                    this.node.setProperty(propertyName, value);
                }
                statname = WebDavStatus.getStatusDescription(200);
            }
            catch (AccessDeniedException e) {
                statname = WebDavStatus.getStatusDescription(403);
            }
            catch (ItemNotFoundException e) {
                statname = WebDavStatus.getStatusDescription(404);
            }
            catch (PathNotFoundException e) {
                statname = WebDavStatus.getStatusDescription(404);
            }
            catch (RepositoryException e) {
                statname = WebDavStatus.getStatusDescription(500);
            }
            if (!propStats.containsKey(statname)) {
                propStats.put(statname, new HashSet());
            }
            propSet = (Set)propStats.get(statname);
            propSet.add(new HierarchicalProperty(setProperty.getName()));
        }
        for (i = 0; i < this.removeList.size(); ++i) {
            HierarchicalProperty removeProperty = this.removeList.get(i);
            try {
                propertyName = WebDavNamespaceContext.createName(removeProperty.getName());
                Property property = this.node.getProperty(propertyName);
                property.remove();
                property.save();
                statname = WebDavStatus.getStatusDescription(200);
            }
            catch (AccessDeniedException e) {
                statname = WebDavStatus.getStatusDescription(403);
            }
            catch (ItemNotFoundException e) {
                statname = WebDavStatus.getStatusDescription(404);
            }
            catch (PathNotFoundException e) {
                statname = WebDavStatus.getStatusDescription(404);
            }
            catch (RepositoryException e) {
                statname = WebDavStatus.getStatusDescription(500);
            }
            if (!propStats.containsKey(statname)) {
                propStats.put(statname, new HashSet());
            }
            propSet = (Set)propStats.get(statname);
            propSet.add(new HierarchicalProperty(removeProperty.getName()));
        }
        return propStats;
    }
}

