/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.portal.application.PortalURLBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.lifecycle.HtmlValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalRequestContext
extends WebuiRequestContext {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalRequestContext");
    public static final int PUBLIC_ACCESS = 0;
    public static final int PRIVATE_ACCESS = 1;
    public static final String UI_COMPONENT_ACTION = "portal:action";
    public static final String UI_COMPONENT_ID = "portal:componentId";
    public static final String CACHE_LEVEL = "portal:cacheLevel";
    private String portalOwner_;
    private String nodePath_;
    private String nodeURI_;
    private String portalURI;
    private int accessPath = -1;
    private HttpServletRequest request_;
    private HttpServletResponse response_;
    private String cacheLevel_ = "cacheLevelPortlet";
    private boolean ajaxRequest_ = true;
    private boolean forceFullUpdate = false;
    private Writer writer_;
    protected JavascriptManager jsmanager_ = new JavascriptManager();

    public JavascriptManager getJavascriptManager() {
        return this.jsmanager_;
    }

    public PortalRequestContext(WebuiApplication app, HttpServletRequest req, HttpServletResponse res) throws Exception {
        super((Application)app);
        int colonIndex;
        this.request_ = req;
        this.response_ = res;
        this.setSessionId(req.getSession().getId());
        this.ajaxRequest_ = "true".equals(req.getParameter("ajaxRequest"));
        String cache = req.getParameter(CACHE_LEVEL);
        if (cache != null) {
            this.cacheLevel_ = cache;
        }
        this.nodeURI_ = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if ((colonIndex = pathInfo.indexOf("/", 1)) < 0) {
            colonIndex = pathInfo.length();
        }
        this.portalOwner_ = pathInfo.substring(1, colonIndex);
        this.nodePath_ = pathInfo.substring(colonIndex, pathInfo.length());
        this.portalURI = this.nodeURI_.substring(0, this.nodeURI_.lastIndexOf(this.nodePath_)) + "/";
        if (this.nodeURI_.indexOf("/public/") >= 0) {
            this.accessPath = 0;
        } else if (this.nodeURI_.indexOf("/private/") >= 0) {
            this.accessPath = 1;
        }
        this.response_.setContentType("text/html; charset=UTF-8");
        try {
            this.request_.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Encoding not supported", (Throwable)e);
        }
        this.urlBuilder = new PortalURLBuilder(this.nodeURI_);
    }

    public String getCacheLevel() {
        return this.cacheLevel_;
    }

    public String getRequestParameter(String name) {
        return this.request_.getParameter(name);
    }

    public String[] getRequestParameterValues(String name) {
        return this.request_.getParameterValues(name);
    }

    public Map<String, String[]> getPortletParameters() {
        Map unsortedParams = this.getRequest().getParameterMap();
        HashMap<String, String[]> sortedParams = new HashMap<String, String[]>();
        Set keys = unsortedParams.keySet();
        for (String key : keys) {
            if (key.startsWith("portal:")) continue;
            sortedParams.put(key, (String[])unsortedParams.get(key));
        }
        return sortedParams;
    }

    public final String getRequestContextPath() {
        return this.request_.getContextPath();
    }

    public String getActionParameterName() {
        return UI_COMPONENT_ACTION;
    }

    public String getUIComponentIdParameterName() {
        return UI_COMPONENT_ID;
    }

    public String getPortalOwner() {
        return this.portalOwner_;
    }

    public String getNodePath() {
        return this.nodePath_;
    }

    public String getNodeURI() {
        return this.nodeURI_;
    }

    public String getPortalURI() {
        return this.portalURI;
    }

    public URLBuilder getURLBuilder() {
        return this.urlBuilder;
    }

    public int getAccessPath() {
        return this.accessPath;
    }

    public final String getRemoteUser() {
        return this.request_.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request_.isUserInRole(roleUser);
    }

    public final Writer getWriter() throws Exception {
        if (this.writer_ == null) {
            this.writer_ = new HtmlValidator((Writer)this.response_.getWriter());
        }
        return this.writer_;
    }

    public final boolean useAjax() {
        return this.ajaxRequest_;
    }

    public final HttpServletRequest getRequest() {
        return this.request_;
    }

    public final HttpServletResponse getResponse() {
        return this.response_;
    }

    public final boolean getFullRender() {
        return this.forceFullUpdate;
    }

    public final void setFullRender(boolean forceFullUpdate) {
        this.forceFullUpdate = forceFullUpdate;
    }

    public void setHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        for (String key : keys) {
            this.response_.setHeader(key, headers.get(key));
        }
    }
}

