/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.webui.application.ConfigurationManager;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class PortalStateManager
extends StateManager {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalStateManager");
    private Map<String, PortalApplicationState> uiApplications = new HashMap<String, PortalApplicationState>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIApplication restoreUIRootComponent(WebuiRequestContext context) throws Exception {
        context.setStateManager((StateManager)this);
        WebuiApplication app = (WebuiApplication)context.getApplication();
        if (context instanceof PortletRequestContext) {
            PortletRequestContext pcontext;
            String key;
            WebuiRequestContext preqContext = (WebuiRequestContext)context.getParentAppRequestContext();
            PortalApplicationState state = this.uiApplications.get(preqContext.getSessionId());
            UIApplication uiApplication = (UIApplication)state.get(key = (pcontext = (PortletRequestContext)context).getApplication().getApplicationId() + "/" + pcontext.getWindowId());
            if (uiApplication != null) {
                return uiApplication;
            }
            Map<String, PortalApplicationState> map = this.uiApplications;
            synchronized (map) {
                ConfigurationManager cmanager = app.getConfigurationManager();
                String uirootClass = cmanager.getApplication().getUIRootComponent();
                Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(uirootClass);
                uiApplication = (UIApplication)app.createUIComponent(type, null, null, context);
                state.put(key, uiApplication);
            }
            return uiApplication;
        }
        PortalRequestContext pcontext = (PortalRequestContext)context;
        PortalApplicationState state = this.uiApplications.get(pcontext.getSessionId());
        if (state != null) {
            if (state.getAccessPath() == 1 && pcontext.getAccessPath() != 1) {
                pcontext.getRequest().getSession().invalidate();
                HttpServletResponse response = pcontext.getResponse();
                response.sendRedirect(pcontext.getNodeURI());
                pcontext.setResponseComplete(true);
                return null;
            }
            if (state.getAccessPath() != pcontext.getAccessPath()) {
                this.clearSession(pcontext.getRequest().getSession());
                state = null;
            } else if (!pcontext.getPortalOwner().equals(state.getUIPortalApplication().getOwner())) {
                this.clearSession(pcontext.getRequest().getSession());
                state = null;
            }
        }
        if (state == null) {
            Map<String, PortalApplicationState> map = this.uiApplications;
            synchronized (map) {
                ConfigurationManager cmanager = app.getConfigurationManager();
                String uirootClass = cmanager.getApplication().getUIRootComponent();
                Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(uirootClass);
                UserPortalConfig config = this.getUserPortalConfig(pcontext);
                String remoteUser = pcontext.getRemoteUser();
                if (config == null && (remoteUser == null || remoteUser.length() < 1)) {
                    pcontext.getRequest().getSession().invalidate();
                    HttpServletResponse response = pcontext.getResponse();
                    response.sendRedirect("/portal/portal-warning.jsp");
                    pcontext.setResponseComplete(true);
                    return null;
                }
                if (config == null) {
                    pcontext.getRequest().getSession().invalidate();
                    HttpServletResponse response = pcontext.getResponse();
                    response.sendRedirect("/portal/portal-unavailable.jsp");
                    pcontext.setResponseComplete(true);
                    return null;
                }
                pcontext.setAttribute(UserPortalConfig.class, config);
                UIPortalApplication uiApplication = (UIPortalApplication)app.createUIComponent(type, config.getPortalConfig().getFactoryId(), null, context);
                state = new PortalApplicationState(uiApplication, pcontext.getAccessPath());
                this.uiApplications.put(context.getSessionId(), state);
                PortalContainer pcontainer = (PortalContainer)app.getApplicationServiceContainer();
                pcontainer.createSessionContainer(context.getSessionId(), uiApplication.getOwner());
            }
        }
        return state.getUIPortalApplication();
    }

    public void storeUIRootComponent(WebuiRequestContext context) {
    }

    public void expire(String sessionId, WebuiApplication app) {
        PortalApplicationState state = this.uiApplications.remove(sessionId);
        if (state != null) {
            log.warn((Object)("Session expires, remove application: " + (Object)((Object)state.getUIPortalApplication())));
        }
        PortalContainer pcontainer = (PortalContainer)app.getApplicationServiceContainer();
        pcontainer.removeSessionContainer(sessionId);
    }

    public UserPortalConfig getUserPortalConfig(PortalRequestContext context) throws Exception {
        ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService service_ = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        String remoteUser = context.getRemoteUser();
        String ownerUser = context.getPortalOwner();
        return service_.getUserPortalConfig(ownerUser, remoteUser);
    }

    private void clearSession(HttpSession session) {
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            session.removeAttribute(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PortalApplicationState
    extends HashMap<String, UIApplication> {
        private UIPortalApplication uiPortalApplication_;
        private int accessPath_;

        public PortalApplicationState(UIPortalApplication uiPortalApplication, int accessPath) {
            this.uiPortalApplication_ = uiPortalApplication;
            this.accessPath_ = accessPath;
        }

        public int getAccessPath() {
            return this.accessPath_;
        }

        public UIPortalApplication getUIPortalApplication() {
            return this.uiPortalApplication_;
        }
    }
}

