/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.portal.webui.UIWelcomeComponent;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.application.UIWidget;
import org.exoplatform.portal.webui.application.UIWidgets;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/application/UIAddNewApplication.gtmpl", events={@EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}), @EventConfig(listeners={AddApplicationActionListener.class})})
public class UIAddNewApplication
extends UIContainer {
    private List<ApplicationCategory> listAppCategories;
    private UIComponent uiComponentParent;
    private boolean isInPage;

    private Application getApplication(String id) throws Exception {
        List<ApplicationCategory> pCategories = this.getApplicationCategories();
        for (ApplicationCategory pCategory : pCategories) {
            List applications = pCategory.getApplications();
            for (Application application : applications) {
                if (!application.getId().equals(id)) continue;
                return application;
            }
        }
        return null;
    }

    public List<ApplicationCategory> getApplicationCategories() throws Exception {
        return this.listAppCategories;
    }

    public List<ApplicationCategory> getApplicationCategories(String remoteUser, String[] applicationType) throws Exception {
        ArrayList appCategories;
        PortalContainer container = PortalContainer.getInstance();
        ApplicationRegistryService prService = (ApplicationRegistryService)container.getComponentInstanceOfType(ApplicationRegistryService.class);
        if (applicationType == null) {
            applicationType = new String[]{};
        }
        if ((appCategories = prService.getApplicationCategories(remoteUser, applicationType)) == null) {
            appCategories = new ArrayList();
        }
        this.listAppCategories = appCategories;
        return this.listAppCategories;
    }

    public UIComponent getUiComponentParent() {
        return this.uiComponentParent;
    }

    public void setUiComponentParent(UIComponent uiComponentParent) {
        this.uiComponentParent = uiComponentParent;
    }

    public boolean isInPage() {
        return this.isInPage;
    }

    public void setInPage(boolean isInPage) {
        this.isInPage = isInPage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddApplicationActionListener
    extends EventListener<UIAddNewApplication> {
        public void execute(Event<UIAddNewApplication> event) throws Exception {
            if (((UIAddNewApplication)((Object)event.getSource())).isInPage()) {
                this.addApplicationToPage(event);
            } else {
                this.addApplicationToContainer(event);
            }
        }

        private void addApplicationToPage(Event<UIAddNewApplication> event) throws Exception {
            StringBuilder windowId;
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIPage uiPage = null;
            if (uiPortal.isRendered()) {
                uiPage = (UIPage)uiPortal.findFirstComponentOfType(UIPage.class);
            } else {
                UIPortalToolPanel uiPortalToolPanel = (UIPortalToolPanel)uiPortalApp.findFirstComponentOfType(UIPortalToolPanel.class);
                uiPage = (UIPage)uiPortalToolPanel.findFirstComponentOfType(UIPage.class);
            }
            String applicationId = event.getRequestContext().getRequestParameter("objectId");
            Application application = ((UIAddNewApplication)((Object)event.getSource())).getApplication(applicationId);
            if ("portlet".equals(application.getApplicationType())) {
                UIPortlet uiPortlet = (UIPortlet)uiPage.createUIComponent(UIPortlet.class, null, null);
                windowId = new StringBuilder(uiPage.getOwnerType());
                windowId.append('#').append(uiPage.getOwnerId());
                windowId.append(":/").append(application.getApplicationGroup() + "/" + application.getApplicationName()).append('/').append(((Object)((Object)uiPortlet)).hashCode());
                uiPortlet.setWindowId(windowId.toString());
                uiPortlet.setPortletInPortal(false);
                if (application != null) {
                    if (application.getDisplayName() != null) {
                        uiPortlet.setTitle(application.getDisplayName());
                    } else if (application.getApplicationName() != null) {
                        uiPortlet.setTitle(application.getApplicationName());
                    }
                    uiPortlet.setDescription(application.getDescription());
                }
                uiPage.addChild((UIComponent)uiPortlet);
            } else if ("eXoWidget".equals(application.getApplicationType())) {
                UIWidget uiWidget = (UIWidget)uiPage.createUIComponent(event.getRequestContext(), UIWidget.class, null, null);
                windowId = new StringBuilder(Util.getUIPortal().getOwner());
                windowId.append(":/").append(application.getApplicationGroup() + "/" + application.getApplicationName()).append('/').append(((Object)((Object)uiWidget)).hashCode());
                uiWidget.setApplicationInstanceId(windowId.toString());
                int posX = (int)(Math.random() * 400.0);
                int posY = (int)(Math.random() * 200.0);
                uiWidget.getProperties().put((Object)"locationX", (Object)String.valueOf(posX));
                uiWidget.getProperties().put((Object)"locationY", (Object)String.valueOf(posY));
                uiPage.addChild(uiWidget);
            }
            if (uiPage.isModifiable()) {
                Page page = PortalDataMapper.toPageModel(uiPage);
                UserPortalConfigService configService = (UserPortalConfigService)uiPortalApp.getApplicationComponent(UserPortalConfigService.class);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                configService.update(page);
            }
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
        }

        private void addApplicationToContainer(Event<UIAddNewApplication> event) throws Exception {
            UIContainer uiWidgetContainer = (UIContainer)((UIAddNewApplication)((Object)event.getSource())).getUiComponentParent();
            String applicationId = event.getRequestContext().getRequestParameter("objectId");
            ApplicationRegistryService service = (ApplicationRegistryService)uiWidgetContainer.getApplicationComponent(ApplicationRegistryService.class);
            Application application = service.getApplication(applicationId);
            if (application == null) {
                return;
            }
            StringBuilder windowId = new StringBuilder("user");
            windowId.append("#").append(event.getRequestContext().getRemoteUser());
            windowId.append(":/").append(application.getApplicationGroup() + "/" + application.getApplicationName()).append('/');
            UIWidget uiWidget = (UIWidget)uiWidgetContainer.createUIComponent(event.getRequestContext(), UIWidget.class, null, null);
            windowId.append(((Object)((Object)uiWidget)).hashCode());
            uiWidget.setApplicationInstanceId(windowId.toString());
            uiWidgetContainer.addChild((UIComponent)uiWidget);
            UIWidgets uiWidgets = (UIWidgets)uiWidgetContainer.getAncestorOfType(UIWidgets.class);
            Widgets widgets = PortalDataMapper.toWidgets(uiWidgets);
            UserPortalConfigService configService = (UserPortalConfigService)uiWidgetContainer.getApplicationComponent(UserPortalConfigService.class);
            configService.update(widgets);
            UIPortalApplication uiPortalApp = (UIPortalApplication)event.getRequestContext().getUIApplication();
            uiPortalApp.getUserPortalConfig().setWidgets(widgets);
            UIWelcomeComponent uiWelcomeComponent = (UIWelcomeComponent)uiWidgetContainer.getAncestorOfType(UIWelcomeComponent.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWelcomeComponent);
        }
    }
}

