/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.application.UIFormInputThemeSelector;
import org.exoplatform.portal.webui.application.UIItemThemeSelector;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletPreferencesImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.persistenceImp.PersistenceManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/portal/webui/portal/UIPortletForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPortletForm
extends UIFormTabPane {
    private UIPortlet uiPortlet_;
    private UIComponent backComponent_;
    private static final String FIELD_THEME = "Theme";
    private static final String FIELD_PORTLET_PREF = "PortletPref";

    public UIPortletForm() throws Exception {
        super("UIPortletForm");
        UIFormInputSet uiPortletPrefSet = (UIFormInputSet)new UIFormInputSet(FIELD_PORTLET_PREF).setRendered(false);
        this.addUIFormInput(uiPortletPrefSet);
        UIFormInputSet uiSettingSet = new UIFormInputSet("PortletSetting");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput("id", "id", null).addValidator(MandatoryValidator.class, new Object[0]).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("windowId", "windowId", null).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("title", "title", null)).addUIFormInput((UIFormInput)new UIFormStringInput("width", "width", null)).addUIFormInput((UIFormInput)new UIFormStringInput("height", "height", null)).addUIFormInput((UIFormInput)new UIFormCheckBoxInput("showInfoBar", "showInfoBar", (Object)false)).addUIFormInput((UIFormInput)new UIFormCheckBoxInput("showPortletMode", "showPortletMode", (Object)false)).addUIFormInput((UIFormInput)new UIFormCheckBoxInput("showWindowState", "showWindowState", (Object)false)).addUIFormInput((UIFormInput)new UIFormTextAreaInput("description", "description", null));
        this.addUIFormInput(uiSettingSet);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("Icon", "icon");
        this.addUIFormInput((UIFormInput)uiIconSelector);
        UIFormInputThemeSelector uiThemeSelector = new UIFormInputThemeSelector(FIELD_THEME, null);
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        ((UIItemThemeSelector)uiThemeSelector.getChild(UIItemThemeSelector.class)).setValues(skinService.getPortletThemes());
        this.addUIFormInput((UIFormInput)uiThemeSelector);
    }

    public UIComponent getBackComponent() {
        return this.backComponent_;
    }

    public void setBackComponent(UIComponent uiComp) throws Exception {
        this.backComponent_ = uiComp;
    }

    public UIPortlet getUIPortlet() {
        return this.uiPortlet_;
    }

    public boolean hasEditMode() {
        return this.uiPortlet_.getSupportModes().contains("edit");
    }

    public String getEditModeContent() {
        StringBuilder portletContent = new StringBuilder();
        try {
            PortalRequestContext prcontext = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
            prcontext.setFullRender(true);
            ExoContainer container = prcontext.getApplication().getApplicationServiceContainer();
            PortletContainerService portletContainer = (PortletContainerService)container.getComponentInstanceOfType(PortletContainerService.class);
            RenderInput input = new RenderInput();
            String baseUrl = prcontext.getNodeURI() + "?portal:componentId" + "=" + this.uiPortlet_.getId();
            input.setBaseURL(baseUrl);
            input.setUserAttributes(new HashMap());
            input.setPortletMode(PortletMode.EDIT);
            input.setWindowState(this.uiPortlet_.getCurrentWindowState());
            input.setMarkup("text/html");
            input.setTitle(this.uiPortlet_.getTitle());
            input.setInternalWindowID((WindowID)this.uiPortlet_.getExoWindowID());
            input.setRenderParameters(this.getRenderParameterMap(this.uiPortlet_));
            input.setPublicParamNames(this.uiPortlet_.getPublicRenderParamNames());
            RenderOutput output = portletContainer.render(prcontext.getRequest(), prcontext.getResponse(), input);
            if (output.getContent() == null) {
                portletContent.append("EXO-ERROR: Portlet container throw an exception\n").append(this.uiPortlet_.getId()).append(" has error");
            } else {
                portletContent.setLength(0);
                portletContent.append(output.getContent());
            }
        }
        catch (Throwable ex) {
            ex = ExceptionUtil.getRootCause((Throwable)ex);
            portletContent.append(ExceptionUtil.getStackTrace((Throwable)ex, (int)100));
            System.err.println("Exception print in the portlet content" + portletContent);
        }
        return portletContent.toString();
    }

    public void setValues(UIPortlet uiPortlet) throws Exception {
        this.uiPortlet_ = uiPortlet;
        this.invokeGetBindingBean((Object)this.uiPortlet_);
        String icon = uiPortlet.getIcon();
        if (icon == null || icon.length() < 0) {
            icon = "PortletIcon";
        }
        ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(icon);
        ((UIItemThemeSelector)((UIFormInputThemeSelector)this.getChild(UIFormInputThemeSelector.class)).getChild(UIItemThemeSelector.class)).setSelectedTheme(uiPortlet.getSuitedTheme(null));
        if (this.hasEditMode()) {
            uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
        } else {
            ExoWindowID windowID = uiPortlet.getExoWindowID();
            Input input = new Input();
            input.setInternalWindowID((WindowID)windowID);
            PortletApplicationsHolder holder = (PortletApplicationsHolder)this.getApplicationComponent(PortletApplicationsHolder.class);
            Portlet pDatas = holder.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
            ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
            PersistenceManager manager = (PersistenceManager)this.getApplicationComponent(PersistenceManager.class);
            PortletWindowInternal windowInfos = manager.getWindow(input, defaultPrefs);
            PortletPreferences preferences = windowInfos.getPreferences();
            UIFormInputSet uiPortletPrefSet = (UIFormInputSet)this.getChildById(FIELD_PORTLET_PREF);
            uiPortletPrefSet.getChildren().clear();
            Enumeration prefNames = preferences.getNames();
            if (!prefNames.hasMoreElements()) {
                this.setSelectedTab("PortletSetting");
                return;
            }
            uiPortletPrefSet.setRendered(true);
            this.setSelectedTab(FIELD_PORTLET_PREF);
            while (prefNames.hasMoreElements()) {
                String name = (String)prefNames.nextElement();
                if (preferences.isReadOnly(name)) continue;
                uiPortletPrefSet.addUIFormInput((UIFormInput)new UIFormStringInput(name, null, preferences.getValue(name, "value")));
            }
        }
    }

    private void savePreferences() throws Exception {
        UIFormInputSet uiPortletPrefSet = (UIFormInputSet)this.getChildById(FIELD_PORTLET_PREF);
        ArrayList uiFormInputs = new ArrayList(3);
        uiPortletPrefSet.findComponentOfType(uiFormInputs, UIFormStringInput.class);
        if (uiFormInputs.size() < 1) {
            return;
        }
        ExoWindowID windowID = this.uiPortlet_.getExoWindowID();
        Input input = new Input();
        input.setInternalWindowID((WindowID)windowID);
        PortletApplicationsHolder holder = (PortletApplicationsHolder)this.getApplicationComponent(PortletApplicationsHolder.class);
        Portlet pDatas = holder.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PersistenceManager manager = (PersistenceManager)this.getApplicationComponent(PersistenceManager.class);
        PortletWindowInternal windowInfos = manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        for (UIFormStringInput ele : uiFormInputs) {
            preferences.setValue(ele.getName(), (String)ele.getValue());
        }
        preferences.setMethodCalledIsAction(1);
        preferences.store();
    }

    private Map<String, String[]> getRenderParameterMap(UIPortlet uiPortlet) {
        Map<String, String[]> renderParams = uiPortlet.getRenderParametersMap();
        if (renderParams == null) {
            renderParams = new HashMap<String, String[]>();
            uiPortlet.setRenderParametersMap(renderParams);
        }
        HashMap<String, String[]> allParams = new HashMap<String, String[]>(renderParams);
        allParams.putAll(uiPortlet.getPublicParameters());
        return allParams;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPortletForm> {
        public void execute(Event<UIPortletForm> event) throws Exception {
            UIPortletForm uiPortletForm = (UIPortletForm)((Object)event.getSource());
            UIPortlet uiPortlet = uiPortletForm.getUIPortlet();
            if (uiPortletForm.hasEditMode()) {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
            Util.showComponentLayoutMode(UIPortlet.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPortletForm> {
        public void execute(Event<UIPortletForm> event) throws Exception {
            UIPortletForm uiPortletForm = (UIPortletForm)((Object)event.getSource());
            UIPortlet uiPortlet = uiPortletForm.getUIPortlet();
            UIFormInputIconSelector uiIconSelector = (UIFormInputIconSelector)uiPortletForm.getChild(UIFormInputIconSelector.class);
            uiPortletForm.invokeSetBindingBean((Object)uiPortlet);
            if (uiIconSelector.getSelectedIcon().equals("Default")) {
                uiPortlet.setIcon("PortletIcon");
            } else {
                uiPortlet.setIcon(uiIconSelector.getSelectedIcon());
            }
            UIFormInputThemeSelector uiThemeSelector = (UIFormInputThemeSelector)uiPortletForm.getChild(UIFormInputThemeSelector.class);
            uiPortlet.putSuitedTheme(null, ((UIItemThemeSelector)uiThemeSelector.getChild(UIItemThemeSelector.class)).getSelectedTheme());
            uiPortletForm.savePreferences();
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortletForm.getParent();
            uiMaskWorkspace.setUIComponent(null);
            if (uiPortletForm.hasEditMode()) {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
            Util.showComponentLayoutMode(UIPortlet.class);
        }
    }
}

