/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/container/UIContainerConfigOptions.gtmpl", initParams={@ParamConfig(name="ContainerConfigOption", value="system:/WEB-INF/conf/uiconf/portal/webui/container/ContainerConfigOption.groovy")}), @ComponentConfig(type=UIDropDownControl.class, id="UIDropDownConfigs", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={ChangeOptionActionListener.class})})})
public class UIContainerConfigOptions
extends org.exoplatform.webui.core.UIContainer {
    private List<SelectItemCategory> categories_;
    private SelectItemCategory selectedCategory_;

    public UIContainerConfigOptions(InitParams initParams) throws Exception {
        this.setComponentConfig(UIContainerConfigOptions.class, null);
        this.selectedCategory_ = null;
        UIDropDownControl uiDropCategories = (UIDropDownControl)this.addChild(UIDropDownControl.class, "UIDropDownConfigs", "UIDropDownConfigs");
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        uiDropCategories.setOptions(options);
        uiDropCategories.setParent((UIComponent)this);
        if (initParams == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Param param = initParams.getParam("ContainerConfigOption");
        this.categories_ = (List)param.getMapGroovyObject(context);
        if (this.categories_ == null) {
            return;
        }
        if (this.selectedCategory_ == null) {
            this.setCategorySelected(this.categories_.get(0));
        }
        for (SelectItemCategory itemCategory : this.categories_) {
            options.add(new SelectItemOption((Object)itemCategory.getName()));
        }
    }

    public void setCategorySelected(SelectItemCategory selectedCategory) {
        this.selectedCategory_ = selectedCategory;
    }

    public void setCategorySelected(String name) {
        for (SelectItemCategory itemCategory : this.categories_) {
            if (!itemCategory.getName().equals(name)) continue;
            this.selectedCategory_ = itemCategory;
            return;
        }
    }

    public SelectItemCategory getCategorySelected() {
        return this.selectedCategory_;
    }

    public List<SelectItemCategory> getCategories() {
        return this.categories_;
    }

    public void setCategories(List<SelectItemCategory> categories) {
        this.categories_ = categories;
    }

    public Container getContainer(String id) throws Exception {
        for (SelectItemCategory category : this.categories_) {
            List items = category.getSelectItemOptions();
            for (SelectItemOption item : items) {
                if (!item.getLabel().equals(id)) continue;
                return this.toContainer(item.getValue().toString());
            }
        }
        return null;
    }

    private Container toContainer(String xml) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        IBindingFactory bfact = BindingDirectory.getFactory(Container.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return (Container)uctx.unmarshalDocument((InputStream)is, null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        Util.showComponentLayoutMode(UIContainer.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeOptionActionListener
    extends EventListener<UIDropDownControl> {
        public void execute(Event<UIDropDownControl> event) throws Exception {
            String selectedContainerId = event.getRequestContext().getRequestParameter("objectId");
            UIDropDownControl uiDropDown = (UIDropDownControl)event.getSource();
            UIContainerConfigOptions uiContainerOptions = (UIContainerConfigOptions)uiDropDown.getParent();
            uiDropDown.setValue(selectedContainerId);
            uiContainerOptions.setCategorySelected(selectedContainerId);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiContainerOptions.getParent());
        }
    }
}

