/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageNavigationUtils {
    public static void removeNode(List<PageNode> list, String uri) {
        if (list == null) {
            return;
        }
        for (PageNode pageNode : list) {
            if (!pageNode.getUri().equalsIgnoreCase(uri)) continue;
            list.remove(pageNode);
            return;
        }
    }

    public static PageNode[] searchPageNodesByUri(PageNode node, String uri) {
        if (node.getUri().equals(uri)) {
            return new PageNode[]{null, node};
        }
        if (node.getChildren() == null) {
            return null;
        }
        List children = node.getChildren();
        for (PageNode ele : children) {
            PageNode[] returnNodes = PageNavigationUtils.searchPageNodesByUri(ele, uri);
            if (returnNodes == null) continue;
            if (returnNodes[0] == null) {
                returnNodes[0] = node;
            }
            return returnNodes;
        }
        return null;
    }

    public static PageNode[] searchPageNodesByUri(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        ArrayList nodes = nav.getNodes();
        for (PageNode ele : nodes) {
            PageNode[] returnNodes = PageNavigationUtils.searchPageNodesByUri(ele, uri);
            if (returnNodes == null) continue;
            return returnNodes;
        }
        return null;
    }

    public static PageNode searchPageNodeByUri(PageNode node, String uri) {
        if (node.getUri().equals(uri)) {
            return node;
        }
        if (node.getChildren() == null) {
            return null;
        }
        List children = node.getChildren();
        for (PageNode ele : children) {
            PageNode returnNode = PageNavigationUtils.searchPageNodeByUri(ele, uri);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public static PageNode searchPageNodeByUri(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        ArrayList nodes = nav.getNodes();
        for (PageNode ele : nodes) {
            PageNode returnNode = PageNavigationUtils.searchPageNodeByUri(ele, uri);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public static Object searchParentNode(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        int last = uri.lastIndexOf("/");
        String parentUri = "";
        if (last > -1) {
            parentUri = uri.substring(0, uri.lastIndexOf("/"));
        }
        for (PageNode ele : nav.getNodes()) {
            if (!ele.getUri().equals(uri)) continue;
            return nav;
        }
        if (parentUri.equals("")) {
            return null;
        }
        return PageNavigationUtils.searchPageNodeByUri(nav, parentUri);
    }

    public static PageNavigation filter(PageNavigation nav, String userName) throws Exception {
        PageNavigation filter = nav.clone();
        filter.setNodes(new ArrayList());
        for (PageNode node : nav.getNodes()) {
            PageNode newNode = PageNavigationUtils.filter(node, userName);
            if (newNode == null) continue;
            filter.addNode(newNode);
        }
        return filter;
    }

    public static PageNode filter(PageNode node, String userName) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        if (userService.getPage(node.getPageReference(), userName) == null) {
            return null;
        }
        PageNode copyNode = node.clone();
        copyNode.setChildren(new ArrayList());
        List children = node.getChildren();
        if (children == null) {
            return copyNode;
        }
        for (PageNode child : children) {
            PageNode newNode = PageNavigationUtils.filter(child, userName);
            if (newNode == null) continue;
            copyNode.getChildren().add(newNode);
        }
        return copyNode;
    }
}

