/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.navigation.UIPageManagement;
import org.exoplatform.portal.webui.navigation.UIPageNavigationControlBar;
import org.exoplatform.portal.webui.navigation.UIPageNodeForm;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageEditBar;
import org.exoplatform.portal.webui.page.UIPageForm;
import org.exoplatform.portal.webui.page.UIPageTemplateOptions;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageNodeActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveDownActionListener
    extends MoveUpActionListener {
        @Override
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            super.moveNode(event, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveUpActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            this.moveNode(event, -1);
        }

        protected void moveNode(Event<UIRightClickPopupMenu> event, int i) {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UIPageNodeSelector.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPageNodeSelector.getParent());
            PageNavigation nav = uiPageNodeSelector.getSelectedNavigation();
            PageNode targetNode = PageNavigationUtils.searchPageNodeByUri(nav, uri);
            Object parentNode = PageNavigationUtils.searchParentNode(nav, uri);
            List<PageNode> children = new ArrayList();
            if (parentNode instanceof PageNavigation) {
                children = ((PageNavigation)parentNode).getNodes();
            } else if (parentNode instanceof PageNode) {
                children = ((PageNode)parentNode).getChildren();
            }
            int k = children.indexOf(targetNode);
            if (k < 0) {
                return;
            }
            if (k == 0 && i == -1) {
                return;
            }
            if (k == children.size() - 1 && i == 1) {
                return;
            }
            children.remove(k);
            children.add(k + i, targetNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PasteNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            boolean hasTargetNode;
            String targetUri = event.getRequestContext().getRequestParameter("objectId");
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiPopupMenu.getAncestorOfType(UIPageNodeSelector.class);
            UIPageManagement uiManagement = (UIPageManagement)uiPageNodeSelector.getParent();
            Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
            uiManagement.setRenderedChildrenOfTypes(childrenToRender);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            UIPageNodeSelector.SelectedNode selectedNode = uiPageNodeSelector.getCopyNode();
            if (selectedNode == null) {
                return;
            }
            PageNode newNode = selectedNode.getNode().clone();
            PageNavigation targetNav = uiPageNodeSelector.getSelectedNavigation();
            PageNode targetNode = PageNavigationUtils.searchPageNodeByUri(targetNav, targetUri);
            boolean bl = hasTargetNode = targetNode != null;
            if (hasTargetNode && newNode.getUri().equals(targetNode.getUri())) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.paste.sameSrcAndDes", null));
                Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (hasTargetNode) {
                this.renewPageNodeUri(targetNode, newNode);
            }
            if (hasTargetNode && this.hasNode(targetNode, newNode.getUri()) || this.hasNode(targetNav, newNode.getUri())) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.paste.sameName", null));
                Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (selectedNode.isDeleteNode()) {
                if (selectedNode.getParentNode() != null) {
                    selectedNode.getParentNode().getChildren().remove(selectedNode.getNode());
                } else {
                    selectedNode.getPageNavigation().getNodes().remove(selectedNode.getNode());
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPageNodeSelector);
            uiPageNodeSelector.setCopyNode(null);
            UITree uitree = (UITree)uiPageNodeSelector.getChild(UITree.class);
            UIRightClickPopupMenu popup = uitree.getUIRightClickPopupMenu();
            popup.setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CutNode", "DeleteNode", "MoveUp", "MoveDown"});
            if (!hasTargetNode) {
                this.renewPageNodeUri(null, newNode);
                targetNav.addNode(newNode);
                return;
            }
            targetNode.getChildren().add(newNode);
            uiPageNodeSelector.selectPageNodeByUri(targetNode.getUri());
        }

        private void renewPageNodeUri(PageNode parent, PageNode current) {
            String newUri = parent != null ? parent.getUri() + "/" + current.getName() : current.getName();
            current.setUri(newUri);
            List children = current.getChildren();
            if (children != null) {
                for (PageNode ele : children) {
                    this.renewPageNodeUri(current, ele);
                }
            }
        }

        private boolean hasNode(PageNode node, String uri) {
            if (node == null) {
                return false;
            }
            List children = node.getChildren();
            if (children == null) {
                node.setChildren(new ArrayList());
                return false;
            }
            for (PageNode ele : children) {
                if (!ele.getUri().equals(uri)) continue;
                return true;
            }
            return false;
        }

        private boolean hasNode(PageNavigation nav, String uri) {
            ArrayList nodes = nav.getNodes();
            for (PageNode ele : nodes) {
                if (!ele.getUri().equals(uri)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CutNodeActionListener
    extends CopyNodeActionListener {
        @Override
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            super.execute(event);
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UIPageNodeSelector.class);
            if (uiPageNodeSelector.getCopyNode() == null) {
                return;
            }
            uiPageNodeSelector.getCopyNode().setDeleteNode(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UIPageNodeSelector.class);
            UIPageManagement uiManagement = (UIPageManagement)uiPageNodeSelector.getParent();
            Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
            uiManagement.setRenderedChildrenOfTypes(childrenToRender);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            PageNavigation nav = uiPageNodeSelector.getSelectedNavigation();
            if (nav == null) {
                return;
            }
            PageNode[] pageNodes = PageNavigationUtils.searchPageNodesByUri(nav, uri);
            if (pageNodes == null) {
                return;
            }
            UIPageNodeSelector.SelectedNode selectedNode = new UIPageNodeSelector.SelectedNode(nav, pageNodes[0], pageNodes[1]);
            selectedNode.setDeleteNode(false);
            uiPageNodeSelector.setCopyNode(selectedNode);
            ((UIRightClickPopupMenu)event.getSource()).setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CutNode", "PasteNode", "DeleteNode", "MoveUp", "MoveDown"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UIPageNodeSelector.class);
            UIPageManagement uiManagement = (UIPageManagement)uiPageNodeSelector.getParent();
            Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
            uiManagement.setRenderedChildrenOfTypes(childrenToRender);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            PageNavigation nav = uiPageNodeSelector.getSelectedNavigation();
            if (nav == null) {
                return;
            }
            PageNode[] pageNodes = PageNavigationUtils.searchPageNodesByUri(nav, uri);
            if (pageNodes == null) {
                return;
            }
            UIPortalToolPanel uiToolPanel = Util.getUIPortalToolPanel();
            uiToolPanel.setUIComponent(null);
            UIWorkspace uiWorkspace = (UIWorkspace)uiToolPanel.getAncestorOfType(UIWorkspace.class);
            pcontext.setFullRender(true);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkspace);
            if (pageNodes[0] == null) {
                nav.getNodes().remove(pageNodes[1]);
                return;
            }
            pageNodes[0].getChildren().remove(pageNodes[1]);
            uiPageNodeSelector.selectPageNodeByUri(pageNodes[0].getUri());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditSelectedNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            UIRightClickPopupMenu popupMenu = (UIRightClickPopupMenu)event.getSource();
            UIComponent parent = popupMenu.getParent();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)parent.getParent();
            UIPortalApplication uiApp = (UIPortalApplication)uiPageNodeSelector.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPageNodeSelector.getParent());
            UIPageNodeForm uiNodeForm = uiMaskWS.createUIComponent(UIPageNodeForm.class, null, null);
            uiMaskWS.setUIComponent((UIComponent)uiNodeForm);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            PageNavigation selectedNav = uiPageNodeSelector.getSelectedNavigation();
            Object obj = PageNavigationUtils.searchParentNode(selectedNav, uri);
            PageNode selectedNode = PageNavigationUtils.searchPageNodeByUri(selectedNav, uri);
            uiNodeForm.setValues(selectedNode);
            uiNodeForm.setSelectedParent(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPageNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiPopupMenu.getAncestorOfType(UIPageNodeSelector.class);
            PageNavigation currentNav = uiPageNodeSelector.getSelectedNavigation();
            PageNode selectNode = PageNavigationUtils.searchPageNodeByUri(currentNav, uri);
            uiPageNodeSelector.selectPageNodeByUri(uri);
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiPortalApp.findFirstComponentOfType(UIPortalToolPanel.class);
            UIPageManagement uiManagement = (UIPageManagement)uiPageNodeSelector.getParent();
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            uiWorkingWS.setRenderedChild(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(true);
            pcontext.setFullRender(true);
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiPopupMenu.getApplicationComponent(UserPortalConfigService.class);
            Page page = portalConfigService.getPage(selectNode.getPageReference(), pcontext.getRemoteUser());
            if (page == null) {
                Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
                uiManagement.setRenderedChildrenOfTypes(childrenToRender);
                uiToolPanel.setUIComponent(null);
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.edit.null", (Object[])new String[0]));
                Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            UIPageEditBar uiPageEditBar = (UIPageEditBar)uiManagement.getChild(UIPageEditBar.class);
            UIPage uiPage = uiPageEditBar.getUIPage();
            if (uiPage == null || !uiPage.getPageId().equals(page.getPageId())) {
                uiPage = Util.toUIPage(page, (UIComponent)uiToolPanel);
            }
            ((UIPageBody)uiPortalApp.findFirstComponentOfType(UIPageBody.class)).setUIComponent(null);
            if (!page.isModifiable()) {
                uiToolPanel.setUIComponent((UIComponent)uiPage);
                Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
                uiManagement.setRenderedChildrenOfTypes(childrenToRender);
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.Invalid-editPermission", null));
                Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            uiPageEditBar.setUIPage(uiPage);
            uiPageEditBar.showUIPage();
            if (!"Desktop".equals(uiPage.getFactoryId())) {
                Class[] childrenToRender = new Class[]{UIPageEditBar.class, UIPageNodeSelector.class, UIPageNavigationControlBar.class};
                uiManagement.setRenderedChildrenOfTypes(childrenToRender);
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            UIPageForm uiPageForm = uiMaskWS.createUIComponent(UIPageForm.class);
            uiPageForm.removeChild(UIPageTemplateOptions.class);
            uiPageForm.setValues(uiPage);
            uiMaskWS.setUIComponent((UIComponent)uiPageForm);
            uiMaskWS.setWindowSize(640, 400);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
            uiManagement.setRenderedChildrenOfTypes(childrenToRender);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiPopupMenu.getAncestorOfType(UIPageNodeSelector.class);
            if (uiPageNodeSelector.getSelectedNavigation() == null) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.NoPageNavigation", null));
                Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                event.getRequestContext().addUIComponentToUpdateByAjax(uiPageNodeSelector.getParent());
                return;
            }
            UIPortalApplication uiApp = (UIPortalApplication)uiPageNodeSelector.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPageNodeSelector.getParent());
            UIPageNodeForm uiNodeForm = uiMaskWS.createUIComponent(UIPageNodeForm.class, null, null);
            uiNodeForm.setValues(null);
            uiMaskWS.setUIComponent((UIComponent)uiNodeForm);
            PageNavigation parent = null;
            ArrayList pageNodes = uiPageNodeSelector.getSelectedNavigation().getNodes();
            if (uri != null && uri.trim().length() > 0) {
                PageNode pageNode;
                Iterator i$ = pageNodes.iterator();
                while (i$.hasNext() && (parent = PageNavigationUtils.searchPageNodeByUri(pageNode = (PageNode)i$.next(), uri)) == null) {
                }
            }
            if (parent == null) {
                parent = uiPageNodeSelector.getSelectedNavigation();
            }
            uiNodeForm.setSelectedParent(parent);
        }
    }
}

