/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.navigation.UIPageManagement;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageEditBar;
import org.exoplatform.portal.webui.page.UIPageSelector;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UIPageNodeForm
extends UIFormTabPane {
    private PageNode pageNode_;
    private Object selectedParent;

    public UIPageNodeForm() throws Exception {
        super("UIPageNodeForm");
        UIFormInputSet uiSettingSet = new UIFormInputSet("PageNodeSetting");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput("uri", "uri", null).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(IdentifierValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormStringInput("label", "label", null));
        this.addUIFormInput(uiSettingSet);
        this.setSelectedTab(uiSettingSet.getId());
        UIPageSelector uiPageSelector = (UIPageSelector)this.createUIComponent(UIPageSelector.class, null, null);
        uiPageSelector.configure("UIPageSelector", "pageReference");
        this.addUIFormInput((UIFormInput)uiPageSelector);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("Icon", "icon");
        this.addUIFormInput((UIFormInput)uiIconSelector);
    }

    public PageNode getPageNode() {
        return this.pageNode_;
    }

    public void setValues(PageNode pageNode) throws Exception {
        this.pageNode_ = pageNode;
        if (pageNode == null) {
            this.getUIStringInput("name").setEditable(true);
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon("Default");
            return;
        }
        this.getUIStringInput("name").setEditable(false);
        String icon = this.pageNode_.getIcon();
        if (icon == null || icon.length() < 0) {
            icon = "Default";
        }
        ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(icon);
        this.invokeGetBindingBean(this.pageNode_);
        this.getUIStringInput("label").setValue((Object)this.pageNode_.getResolvedLabel());
    }

    public Object getSelectedParent() {
        return this.selectedParent;
    }

    public void setSelectedParent(Object obj) {
        this.selectedParent = obj;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        UIPageSelector uiPageSelector = (UIPageSelector)this.getChild(UIPageSelector.class);
        if (uiPageSelector == null) {
            return;
        }
        UIPopupWindow uiPopupWindowPage = (UIPopupWindow)uiPageSelector.getChild(UIPopupWindow.class);
        if (uiPopupWindowPage == null) {
            return;
        }
        uiPopupWindowPage.processRender(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiPageNodeForm = (UIPageNodeForm)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)uiPageNodeForm.getChild(UIPageSelector.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageNodeForm.getAncestorOfType(UIPortalApplication.class);
            if (pageSelector.getPage() == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.selectPage", null));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            PageNode pageNode = uiPageNodeForm.getPageNode();
            if (pageNode == null) {
                pageNode = new PageNode();
            }
            uiPageNodeForm.invokeSetBindingBean(pageNode);
            UIFormInputIconSelector uiIconSelector = (UIFormInputIconSelector)uiPageNodeForm.getChild(UIFormInputIconSelector.class);
            if (uiIconSelector.getSelectedIcon().equals("Default")) {
                pageNode.setIcon(null);
            } else {
                pageNode.setIcon(uiIconSelector.getSelectedIcon());
            }
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiControl.findFirstComponentOfType(UIPageNodeSelector.class);
            UIPortalToolPanel uiToolPanel = Util.getUIPortalToolPanel();
            UIPage uiPage = Util.toUIPage(pageSelector.getPage(), (UIComponent)uiToolPanel);
            uiToolPanel.setShowMaskLayer(true);
            uiToolPanel.setUIComponent((UIComponent)uiPage);
            uiToolPanel.setRenderSibbling(UIPortalToolPanel.class);
            String remoteUser = pcontext.getRemoteUser();
            Object selectedParent = uiPageNodeForm.getSelectedParent();
            PageNavigation pageNav = null;
            if (selectedParent instanceof PageNavigation) {
                pageNav = (PageNavigation)selectedParent;
                pageNav.setModifier(remoteUser);
                pageNode.setUri(pageNode.getName());
                if (!pageNav.getNodes().contains(pageNode)) {
                    if (uiPageNodeSelector.searchPageNodeByUri(pageNav, pageNode.getUri()) != null) {
                        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
                        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
                        uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.SameName", null));
                        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                        return;
                    }
                    pageNav.addNode(pageNode);
                }
            } else if (selectedParent instanceof PageNode) {
                PageNode parentNode = (PageNode)selectedParent;
                ArrayList<PageNode> children = parentNode.getChildren();
                if (children == null) {
                    children = new ArrayList<PageNode>();
                    parentNode.setChildren(children);
                }
                pageNode.setUri(parentNode.getUri() + "/" + pageNode.getName());
                if (!children.contains(pageNode)) {
                    if (PageNavigationUtils.searchPageNodeByUri(parentNode, pageNode.getUri()) != null) {
                        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
                        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
                        uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.SameName", null));
                        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                        return;
                    }
                    children.add(pageNode);
                }
            }
            if (pageNode.getLabel() == null) {
                pageNode.setLabel(pageNode.getName());
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            UIPageManagement uiManagement = (UIPageManagement)uiPortalApp.findFirstComponentOfType(UIPageManagement.class);
            UIPageNodeSelector pageNodeSelector = (UIPageNodeSelector)uiManagement.getChild(UIPageNodeSelector.class);
            pageNodeSelector.selectPageNodeByUri(pageNode.getUri());
            UIPageEditBar editBar = (UIPageEditBar)uiManagement.getChild(UIPageEditBar.class);
            editBar.setUIPage(uiPage);
            if (uiPage.getFactoryId() != null) {
                editBar.setRendered(uiPage.isModifiable() && !uiPage.getFactoryId().equals("Desktop"));
            } else {
                editBar.setRendered(uiPage.isModifiable());
            }
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            pcontext.addUIComponentToUpdateByAjax(uiToolPanel.getParent());
            pcontext.setFullRender(true);
        }
    }
}

