/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBody.gtmpl")
public class UIPageBody
extends UIComponentDecorator {
    private UIPortalComponent maximizedUIComponent;

    public UIPageBody(PageBody model) throws Exception {
        this.setId("UIPageBody");
    }

    public UIPageBody() throws Exception {
        this.setId("UIPageBody");
    }

    public void init(PageBody model) throws Exception {
        this.setId("UIPageBody");
    }

    public void setPageBody(PageNode pageNode, UIPortal uiPortal) throws Exception {
        if (pageNode == null) {
            this.setPage(null, uiPortal);
            return;
        }
        this.setPage(pageNode.getPageReference(), uiPortal);
    }

    private void setPage(String pageId, UIPortal uiPortal) throws Exception {
        PortalRequestContext context = Util.getPortalRequestContext();
        ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        Page page = null;
        UIPage uiPage = null;
        if (pageId != null) {
            try {
                page = userPortalConfigService.getPage(pageId, context.getRemoteUser());
            }
            catch (Exception e) {
                UIPortalApplication uiApp = (UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class);
                uiApp.addMessage(new ApplicationMessage(e.getMessage(), new Object[0]));
            }
        }
        if (page != null) {
            if ("Default".equals(page.getFactoryId())) {
                page.setFactoryId(null);
            }
            uiPage = (UIPage)this.createUIComponent(context, UIPage.class, page.getFactoryId(), null);
            PortalDataMapper.toUIPage(uiPage, page);
            if (uiPage.isShowMaxWindow()) {
                uiPortal.setMaximizedUIComponent((UIComponent)uiPage);
            } else {
                uiPortal.setMaximizedUIComponent(null);
            }
        }
        this.setUIComponent((UIComponent)uiPage);
    }

    public void renderChildren() throws Exception {
        if (this.maximizedUIComponent != null) {
            this.maximizedUIComponent.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
            return;
        }
        if (this.uicomponent_ == null) {
            this.setPageBody(Util.getUIPortal().getSelectedNode(), Util.getUIPortal());
        }
        if (this.uicomponent_ != null) {
            this.uicomponent_.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
        }
    }

    public UIPortalComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIPortalComponent uiMaximizedComponent) {
        this.maximizedUIComponent = uiMaximizedComponent;
    }
}

