/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.UIPageNavigationActionListener;
import org.exoplatform.portal.webui.navigation.UIPageNodeActionListener;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.UIWizard;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/page/UIWizardPageSetInfo.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="WizardPageNodeSelector", type=UIPageNodeSelector.class, template="app:/groovy/portal/webui/navigation/UIPageNodeSelector.gtmpl", events={@EventConfig(listeners={SelectNavigationActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="PageNodePopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={UIPageNodeActionListener.AddNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.EditPageNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.EditSelectedNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.CopyNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.CutNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.PasteNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.MoveUpActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.MoveDownActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.DeleteNodeActionListener.class}, confirm="UIPageNodeSelector.deleteNavigation")}), @ComponentConfig(id="UIPageNodeSelectorPopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={UIPageNodeActionListener.AddNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.PasteNodeActionListener.class}), @EventConfig(listeners={UIPageNavigationActionListener.SaveNavigationActionListener.class}), @EventConfig(listeners={UIPageNavigationActionListener.EditNavigationActionListener.class}), @EventConfig(listeners={UIPageNavigationActionListener.DeleteNavigationActionListener.class}, confirm="UIPageNodeSelector.deleteNode")}), @ComponentConfig(type=UIDropDownControl.class, id="UIDropDown", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={UIPageNodeSelector.SelectNavigationActionListener.class})})})
public class UIWizardPageSetInfo
extends UIForm {
    private static final String PAGE_NAME = "pageName";
    private static final String PAGE_DISPLAY_NAME = "pageDisplayName";
    private boolean isEditMode = false;
    private boolean firstTime = true;

    public UIWizardPageSetInfo() throws Exception {
        UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)this.addChild(UIPageNodeSelector.class, "WizardPageNodeSelector", null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_NAME, "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_DISPLAY_NAME, "label", null));
        UITree uiTree = (UITree)uiPageNodeSelector.getChild(UITree.class);
        uiTree.setUIRightClickPopupMenu(null);
        uiPageNodeSelector.removeChild(UIRightClickPopupMenu.class);
    }

    public void setEditMode() throws Exception {
        this.isEditMode = true;
        UIFormStringInput uiNameInput = (UIFormStringInput)this.getChildById(PAGE_NAME);
        uiNameInput.setEditable(false);
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public PageNode getPageNode() throws Exception {
        UIPageNodeSelector uiNodeSelector;
        PageNode selectedNode;
        if (this.isEditMode) {
            PageNode pageNode = this.getSelectedPageNode();
            this.invokeSetBindingBean(pageNode);
            if (pageNode.getLabel() == null || pageNode.getLabel().trim().length() == 0) {
                pageNode.setLabel(pageNode.getName());
            }
            return pageNode;
        }
        PageNode pageNode = new PageNode();
        this.invokeSetBindingBean(pageNode);
        if (pageNode.getLabel() == null || pageNode.getLabel().trim().length() == 0) {
            pageNode.setLabel(pageNode.getName());
        }
        if ((selectedNode = (uiNodeSelector = (UIPageNodeSelector)this.getChild(UIPageNodeSelector.class)).getSelectedPageNode()) != null) {
            pageNode.setUri(selectedNode.getUri() + "/" + pageNode.getName());
        } else {
            pageNode.setUri(pageNode.getName());
        }
        return pageNode;
    }

    public PageNode getSelectedPageNode() {
        UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)this.getChild(UIPageNodeSelector.class);
        return uiPageNodeSelector.getSelectedPageNode();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.isEditMode && ((UIPageNodeSelector)this.getChild(UIPageNodeSelector.class)).getSelectedPageNode() == null) {
            this.reset();
        }
        super.processRender(context);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        String action = context.getRequestParameter("formOp");
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIWizardPageSetInfo uiForm = (UIWizardPageSetInfo)((Object)event.getSource());
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UIWizardPageSetInfo)((Object)event.getSource())).getChild(UIPageNodeSelector.class);
            UITree tree = (UITree)uiPageNodeSelector.getChild(UITree.class);
            if (tree.getParentSelected() == null && (uri == null || uri.length() < 1)) {
                uiPageNodeSelector.selectNavigation(uiPageNodeSelector.getSelectedNavigation().getId());
            } else {
                uiPageNodeSelector.selectPageNodeByUri(uri);
            }
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageNodeSelector.getAncestorOfType(UIPortalApplication.class);
            UIWizard uiWizard = (UIWizard)uiPortalApp.findFirstComponentOfType(UIWizard.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizard);
            if (!((UIWizardPageSetInfo)((Object)event.getSource())).isEditMode()) {
                return;
            }
            PageNode pageNode = uiPageNodeSelector.getSelectedPageNode();
            if (pageNode == null && uiForm.isFirstTime()) {
                uiForm.setFirstTime(false);
                UIPortal uiPortal = Util.getUIPortal();
                uiPageNodeSelector.selectNavigation(uiPortal.getSelectedNavigation().getId());
                uiPageNodeSelector.selectPageNodeByUri(uiPortal.getSelectedNode().getUri());
                pageNode = uiPageNodeSelector.getSelectedPageNode();
            }
            if (pageNode == null) {
                return;
            }
            UserPortalConfigService configService = (UserPortalConfigService)uiWizard.getApplicationComponent(UserPortalConfigService.class);
            String accessUser = event.getRequestContext().getRemoteUser();
            Page page = configService.getPage(pageNode.getPageReference(), accessUser);
            if (page == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIWizardPageSetInfo.msg.null", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                uiForm.reset();
                return;
            }
            String pageName = pageNode.getPageReference().split("::")[2];
            UIFormStringInput uiNameInput = (UIFormStringInput)uiForm.getChildById(UIWizardPageSetInfo.PAGE_NAME);
            if (pageNode.getName() != null) {
                uiNameInput.setValue((Object)pageName);
            }
            UIFormStringInput uiDisplayNameInput = (UIFormStringInput)uiForm.getChildById(UIWizardPageSetInfo.PAGE_DISPLAY_NAME);
            if (pageNode.getLabel() != null) {
                uiDisplayNameInput.setValue((Object)pageNode.getResolvedLabel());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectNavigationActionListener
    extends EventListener<UIPageNodeSelector> {
        public void execute(Event<UIPageNodeSelector> event) throws Exception {
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((Object)event.getSource());
            UIWizard uiWizard = (UIWizard)uiPageNodeSelector.getAncestorOfType(UIWizard.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizard);
            if (id != null) {
                uiPageNodeSelector.selectNavigation(id);
            }
        }
    }
}

