/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.UILoginForm;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.application.UIPortletOptions;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UIContainerConfigOptions;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UILanguageSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPortalComponentActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWorkspace.createUIComponent(UILanguageSelector.class, null, null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveChildActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            UIPortalApplication uiApp;
            UIComponent uiWorking;
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String insertPosition = pcontext.getRequestParameter("insertPosition");
            int position = -1;
            try {
                position = Integer.parseInt(insertPosition);
            }
            catch (Exception exp) {
                position = -1;
            }
            boolean newComponent = false;
            String paramNewComponent = pcontext.getRequestParameter("newComponent");
            if (paramNewComponent != null) {
                newComponent = Boolean.valueOf(paramNewComponent);
            }
            if (newComponent) {
                UIPortalApplication uiPortalApp = (UIPortalApplication)((org.exoplatform.webui.core.UIContainer)event.getSource()).getAncestorOfType(UIPortalApplication.class);
                UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                pcontext.setFullRender(true);
            }
            if (!(uiWorking = (uiApp = (UIPortalApplication)Util.getPortalRequestContext().getUIApplication()).findFirstComponentOfType(UIPortal.class)).isRendered()) {
                uiWorking = uiApp.findFirstComponentOfType(UIPortalToolPanel.class);
            }
            String sourceId = pcontext.getRequestParameter("srcID");
            Object uiSource = uiWorking.findComponentById(sourceId);
            org.exoplatform.webui.core.UIContainer uiTarget = (org.exoplatform.webui.core.UIContainer)uiWorking.findComponentById(pcontext.getRequestParameter("targetID"));
            if (position < 0 && uiTarget.getChildren().size() > 0) {
                position = uiTarget.getChildren().size();
            } else if (position < 0) {
                position = 0;
            }
            if (uiSource == null) {
                UIContainerConfigOptions uiContainerConfig = (UIContainerConfigOptions)uiApp.findFirstComponentOfType(UIContainerConfigOptions.class);
                if (uiContainerConfig != null && uiContainerConfig.isRendered()) {
                    UIContainer uiContainer = (UIContainer)uiTarget.createUIComponent(UIContainer.class, null, null);
                    Container container = uiContainerConfig.getContainer(sourceId);
                    container.setId(String.valueOf(container.hashCode()));
                    PortalDataMapper.toUIContainer(uiContainer, container);
                    uiSource = uiContainer;
                } else {
                    UIPortletOptions uiPortletOptions = (UIPortletOptions)uiApp.findFirstComponentOfType(UIPortletOptions.class);
                    Application portlet = uiPortletOptions.getPortlet(sourceId);
                    UIPortlet uiPortlet = (UIPortlet)uiTarget.createUIComponent(UIPortlet.class, null, null);
                    if (portlet.getDisplayName() != null) {
                        uiPortlet.setTitle(portlet.getDisplayName());
                    } else if (portlet.getApplicationName() != null) {
                        uiPortlet.setTitle(portlet.getApplicationName());
                    }
                    uiPortlet.setDescription(portlet.getDescription());
                    StringBuilder windowId = new StringBuilder();
                    UIPage uiPage = (UIPage)uiTarget.getAncestorOfType(UIPage.class);
                    if (uiPage != null) {
                        windowId.append(uiPage.getOwnerType());
                    } else {
                        windowId.append("portal");
                    }
                    windowId.append('#').append(Util.getUIPortal().getOwner()).append(":/");
                    uiPortlet.setPortletInPortal(uiTarget instanceof UIPortal);
                    windowId.append(portlet.getApplicationGroup() + "/" + portlet.getApplicationName()).append('/');
                    windowId.append(((Object)((Object)uiPortlet)).hashCode());
                    uiPortlet.setWindowId(windowId.toString());
                    uiPortlet.setShowEditControl(true);
                    uiSource = uiPortlet;
                }
                List children = uiTarget.getChildren();
                uiSource.setParent((UIComponent)uiTarget);
                children.add(position, uiSource);
                Util.showComponentLayoutMode(uiSource.getClass());
                return;
            }
            org.exoplatform.webui.core.UIContainer uiParent = (org.exoplatform.webui.core.UIContainer)uiSource.getParent();
            if (uiParent == uiTarget) {
                int currentIdx = uiTarget.getChildren().indexOf(uiSource);
                if (position <= currentIdx) {
                    uiTarget.getChildren().add(position, uiSource);
                    uiTarget.getChildren().remove(++currentIdx);
                    return;
                }
                uiTarget.getChildren().remove(currentIdx);
                if (position >= uiTarget.getChildren().size()) {
                    position = uiTarget.getChildren().size();
                }
                uiTarget.getChildren().add(position, uiSource);
                return;
            }
            uiParent.getChildren().remove(uiSource);
            uiTarget.getChildren().add(position, uiSource);
            uiSource.setParent((UIComponent)uiTarget);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteComponentActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIComponent uiComponent = (UIComponent)event.getSource();
            UIPortalComponent uiParent = (UIPortalComponent)uiComponent.getParent();
            UIComponent uiRemoveComponent = uiParent.removeChildById(id);
            Util.showComponentLayoutMode(uiRemoveComponent.getClass());
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiParent.getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveJSApplicationToDesktopActionListener
    extends EventListener<UIPortalComponent> {
        public void execute(Event<UIPortalComponent> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIPage uiPage = (UIPage)uiApp.findFirstComponentOfType(UIPage.class);
            String id = event.getRequestContext().getRequestParameter("jsInstanceId");
            uiPage.removeChildById(id);
            Page page = PortalDataMapper.toPageModel(uiPage);
            UserPortalConfigService configService = (UserPortalConfigService)uiPortal.getApplicationComponent(UserPortalConfigService.class);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            configService.update(page);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowLoginFormActionListener
    extends EventListener<UIPortalComponent> {
        public void execute(Event<UIPortalComponent> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UILoginForm uiLoginForm = uiMaskWS.createUIComponent(UILoginForm.class, null, "UIPortalComponentLogin");
            uiMaskWS.setUIComponent((UIComponent)uiLoginForm);
            uiMaskWS.setWindowSize(630, -1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewChildActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            org.exoplatform.webui.core.UIContainer uiContainer = (org.exoplatform.webui.core.UIContainer)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            uiContainer.setRenderedChild(id);
        }
    }
}

