/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.MapperListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.modeler.Registry;

public class Connector
implements Lifecycle,
MBeanRegistration {
    private static Log log = LogFactory.getLog(Connector.class);
    public static final boolean RECYCLE_FACADES = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.RECYCLE_FACADES", "false"));
    protected Service service = null;
    protected boolean allowTrace = false;
    protected Container container = null;
    protected boolean emptySessionPath = false;
    protected boolean enableLookups = false;
    protected boolean xpoweredBy = false;
    protected static final String info = "org.apache.catalina.connector.Connector/2.1";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected int port = 0;
    protected String proxyName = null;
    protected int proxyPort = 0;
    protected int redirectPort = 443;
    protected String scheme = "http";
    protected boolean secure = false;
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected boolean initialized = false;
    protected boolean started = false;
    protected boolean stopped = false;
    protected boolean useIPVHosts = false;
    protected Thread thread = null;
    protected String protocolHandlerClassName = "org.apache.coyote.http11.Http11Protocol";
    protected ProtocolHandler protocolHandler = null;
    protected Adapter adapter = null;
    protected Mapper mapper = new Mapper();
    protected MapperListener mapperListener = new MapperListener(this.mapper);
    protected String URIEncoding = null;
    protected boolean useBodyEncodingForURI = false;
    protected static HashMap replacements = new HashMap();
    private static final int TCN_REQUIRED_MAJOR = 1;
    private static final int TCN_REQUIRED_MINOR = 1;
    private static final int TCN_REQUIRED_PATCH = 3;
    private static boolean aprInitialized;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    ObjectName controller;

    public Connector() throws Exception {
        this(null);
    }

    public Connector(String protocol) throws Exception {
        this.setProtocol(protocol);
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            this.protocolHandler = (ProtocolHandler)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)this.sm.getString("coyoteConnector.protocolHandlerInstantiationFailed", e));
        }
    }

    public Object getProperty(String name) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = (String)replacements.get(name);
        }
        return IntrospectionUtils.getProperty((Object)this.protocolHandler, (String)repl);
    }

    public boolean setProperty(String name, String value) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = (String)replacements.get(name);
        }
        return IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)repl, (String)value);
    }

    public Object getAttribute(String name) {
        return this.getProperty(name);
    }

    public void setAttribute(String name, Object value) {
        this.setProperty(name, String.valueOf(value));
    }

    public void removeProperty(String name) {
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
        this.setProperty("allowTrace", String.valueOf(allowTrace));
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return 2048;
    }

    public void setBufferSize(int bufferSize) {
    }

    public Container getContainer() {
        if (this.container == null) {
            this.findContainer();
        }
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public boolean getEmptySessionPath() {
        return this.emptySessionPath;
    }

    public void setEmptySessionPath(boolean emptySessionPath) {
        this.emptySessionPath = emptySessionPath;
        this.setProperty("emptySessionPath", String.valueOf(emptySessionPath));
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
        this.setProperty("enableLookups", String.valueOf(enableLookups));
    }

    public String getInfo() {
        return info;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
        this.setProperty("maxSavePostSize", String.valueOf(maxSavePostSize));
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.setProperty("port", String.valueOf(port));
    }

    public String getProtocol() {
        if ("org.apache.coyote.http11.Http11Protocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.http11.Http11AprProtocol".equals(this.getProtocolHandlerClassName())) {
            return "HTTP/1.1";
        }
        if ("org.apache.jk.server.JkCoyoteHandler".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.ajp.AjpAprProtocol".equals(this.getProtocolHandlerClassName())) {
            return "AJP/1.3";
        }
        return this.getProtocolHandlerClassName();
    }

    private static synchronized void initializeAPR() {
        String methodName;
        if (aprInitialized) {
            return;
        }
        int major = 0;
        int minor = 0;
        int patch = 0;
        try {
            methodName = "initialize";
            Class[] paramTypes = new Class[]{String.class};
            Object[] paramValues = new Object[]{null};
            Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
            Method method = clazz.getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
            minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
            patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
        }
        catch (Throwable t) {
            return;
        }
        if (major != 1 || minor != 1 || patch < 3) {
            try {
                methodName = "terminate";
                Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, null);
                method.invoke(null, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        aprInitialized = true;
    }

    public void setProtocol(String protocol) {
        Connector.initializeAPR();
        if (aprInitialized) {
            if ("HTTP/1.1".equals(protocol)) {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            } else if ("AJP/1.3".equals(protocol)) {
                this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpAprProtocol");
            } else if (protocol != null) {
                this.setProtocolHandlerClassName(protocol);
            } else {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            }
        } else if ("HTTP/1.1".equals(protocol)) {
            this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11Protocol");
        } else if ("AJP/1.3".equals(protocol)) {
            this.setProtocolHandlerClassName("org.apache.jk.server.JkCoyoteHandler");
        } else if (protocol != null) {
            this.setProtocolHandlerClassName(protocol);
        }
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        if (proxyName != null && proxyName.length() > 0) {
            this.proxyName = proxyName;
            this.setProperty("proxyName", proxyName);
        } else {
            this.proxyName = null;
            this.removeProperty("proxyName");
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setProperty("proxyPort", String.valueOf(proxyPort));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
        this.setProperty("redirectPort", String.valueOf(redirectPort));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.setProperty("secure", Boolean.toString(secure));
    }

    public String getURIEncoding() {
        return this.URIEncoding;
    }

    public void setURIEncoding(String URIEncoding) {
        this.URIEncoding = URIEncoding;
        this.setProperty("uRIEncoding", URIEncoding);
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
        this.setProperty("useBodyEncodingForURI", String.valueOf(useBodyEncodingForURI));
    }

    public boolean getXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
        this.setProperty("xpoweredBy", String.valueOf(xpoweredBy));
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.useIPVHosts = useIPVHosts;
        this.setProperty("useIPVHosts", String.valueOf(useIPVHosts));
    }

    public boolean getUseIPVHosts() {
        return this.useIPVHosts;
    }

    public Request createRequest() {
        Request request = new Request();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Response response = new Response();
        response.setConnector(this);
        return response;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected ObjectName createObjectName(String domain, String type) throws MalformedObjectNameException {
        String encodedAddr = null;
        if (this.getProperty("address") != null) {
            encodedAddr = URLEncoder.encode(this.getProperty("address").toString());
        }
        String addSuffix = this.getProperty("address") == null ? "" : ",address=" + encodedAddr;
        ObjectName _oname = new ObjectName(domain + ":type=" + type + ",port=" + this.getPort() + addSuffix);
        return _oname;
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            if (log.isInfoEnabled()) {
                log.info((Object)this.sm.getString("coyoteConnector.alreadyInitialized"));
            }
            return;
        }
        this.initialized = true;
        if (this.oname == null && this.container instanceof StandardEngine) {
            try {
                StandardEngine cb = (StandardEngine)this.container;
                this.oname = this.createObjectName(cb.getName(), "Connector");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                this.controller = this.oname;
            }
            catch (Exception e) {
                log.error((Object)"Error registering connector ", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating name for connector " + this.oname));
            }
        }
        this.adapter = new CoyoteAdapter(this);
        this.protocolHandler.setAdapter(this.adapter);
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"jkHome", (String)System.getProperty("catalina.base"));
        try {
            this.protocolHandler.init();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerInitializationFailed", e));
        }
    }

    public void pause() throws LifecycleException {
        try {
            this.protocolHandler.pause();
        }
        catch (Exception e) {
            log.error((Object)this.sm.getString("coyoteConnector.protocolHandlerPauseFailed"), (Throwable)e);
        }
    }

    public void resume() throws LifecycleException {
        try {
            this.protocolHandler.resume();
        }
        catch (Exception e) {
            log.error((Object)this.sm.getString("coyoteConnector.protocolHandlerResumeFailed"), (Throwable)e);
        }
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)this.sm.getString("coyoteConnector.alreadyStarted"));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).registerComponent((Object)this.protocolHandler, this.createObjectName(this.domain, "ProtocolHandler"), null);
            }
            catch (Exception ex) {
                log.error((Object)this.sm.getString("coyoteConnector.protocolRegistrationFailed"), (Throwable)ex);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("coyoteConnector.cannotRegisterProtocol"));
        }
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            String errPrefix = "";
            if (this.service != null) {
                errPrefix = errPrefix + "service.getName(): \"" + this.service.getName() + "\"; ";
            }
            throw new LifecycleException(errPrefix + " " + this.sm.getString("coyoteConnector.protocolHandlerStartFailed", e));
        }
        if (this.domain != null) {
            this.mapperListener.setDomain(this.domain);
            this.mapperListener.init();
            try {
                ObjectName mapperOname = this.createObjectName(this.domain, "Mapper");
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.sm.getString("coyoteConnector.MapperRegistration", mapperOname));
                }
                Registry.getRegistry(null, null).registerComponent((Object)this.mapper, mapperOname, "Mapper");
            }
            catch (Exception ex) {
                log.error((Object)this.sm.getString("coyoteConnector.protocolRegistrationFailed"), (Throwable)ex);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            log.error((Object)this.sm.getString("coyoteConnector.notStarted"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            this.mapperListener.destroy();
            Registry.getRegistry(null, null).unregisterComponent(this.createObjectName(this.domain, "Mapper"));
            Registry.getRegistry(null, null).unregisterComponent(this.createObjectName(this.domain, "ProtocolHandler"));
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)this.sm.getString("coyoteConnector.protocolUnregistrationFailed"), (Throwable)e);
        }
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerDestroyFailed", e));
        }
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Unregistering - can't stop", t);
        }
    }

    protected void findContainer() {
        try {
            ObjectName engName;
            ObjectName parentName = new ObjectName(this.domain + ":" + "type=Service");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding to " + parentName));
            }
            if (this.mserver.isRegistered(parentName)) {
                this.mserver.invoke(parentName, "addConnector", new Object[]{this}, new String[]{"org.apache.catalina.connector.Connector"});
            }
            if (this.mserver.isRegistered(engName = new ObjectName(this.domain + ":" + "type=Engine"))) {
                Object obj = this.mserver.getAttribute(engName, "managedResource");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found engine " + obj + " " + obj.getClass()));
                }
                this.container = (Container)obj;
                this.initialize();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initialized");
                }
                return;
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error finding container " + ex));
        }
    }

    public void init() throws Exception {
        if (this.getService() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Already configured");
            }
            return;
        }
        if (this.container == null) {
            this.findContainer();
        }
    }

    public void destroy() throws Exception {
        if (this.oname != null && this.controller == this.oname) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unregister itself " + this.oname));
            }
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.getService() == null) {
            return;
        }
        this.getService().removeConnector(this);
    }

    static {
        replacements.put("acceptCount", "backlog");
        replacements.put("connectionLinger", "soLinger");
        replacements.put("connectionTimeout", "soTimeout");
        replacements.put("connectionUploadTimeout", "timeout");
        replacements.put("clientAuth", "clientauth");
        replacements.put("keystoreFile", "keystore");
        replacements.put("randomFile", "randomfile");
        replacements.put("rootFile", "rootfile");
        replacements.put("keystorePass", "keypass");
        replacements.put("keystoreType", "keytype");
        replacements.put("sslProtocol", "protocol");
        replacements.put("sslProtocols", "protocols");
        aprInitialized = false;
    }
}

