/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.jcr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExpireKeyStartWithSelector;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.impl.BaseResourceBundleService;
import org.exoplatform.services.resources.jcr.DataMapper;

public class ResourceBundleServiceImpl
extends BaseResourceBundleService {
    RegistryService regService_;
    DataMapper mapper_ = new DataMapper();
    private static final String SERVICE_NAME = "ResourceBundles";

    public ResourceBundleServiceImpl(InitParams params, LogService lservice, CacheService cService, RegistryService service, LocaleConfigService localeService) throws Exception {
        this.log_ = lservice.getLog("org.exoplatform.services.resources");
        this.localeService_ = localeService;
        this.cache_ = cService.getCacheInstance(ResourceBundleData.class.getName());
        this.regService_ = service;
        this.initParams(params);
    }

    public ResourceBundleData getResourceBundleData(String id) throws Exception {
        RegistryEntry entry;
        String resourceDataPath = this.getServiceRegistryPath() + "/" + id;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, resourceDataPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        ResourceBundleData resourceData = this.mapper_.toResourceBundleData(entry.getDocument());
        sessionProvider.close();
        return resourceData;
    }

    public ResourceBundleData removeResourceBundleData(String id) throws Exception {
        ResourceBundleData resource = this.getResourceBundleData(id);
        if (resource == null) {
            return null;
        }
        String resourceDataPath = this.getServiceRegistryPath() + "/" + id;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, resourceDataPath);
        this.cache_.remove((Serializable)((Object)id));
        sessionProvider.close();
        return resource;
    }

    public void saveResourceBundle(ResourceBundleData resourceData) throws Exception {
        RegistryEntry entry;
        String id = resourceData.getId();
        String servicePath = this.getServiceRegistryPath();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, servicePath + "/" + id);
        }
        catch (PathNotFoundException ie) {
            entry = new RegistryEntry(id);
            this.regService_.createEntry(sessionProvider, servicePath, entry);
        }
        this.mapper_.map(entry.getDocument(), resourceData);
        this.regService_.recreateEntry(sessionProvider, servicePath, entry);
        this.cache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(id));
        sessionProvider.close();
    }

    public PageList findResourceDescriptions(Query q) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
        StringBuilder builder = new StringBuilder("select * from exo:registryEntry");
        this.generateScript(builder, "jcr:path", regNode.getPath() + "/" + this.getServiceRegistryPath() + "/%");
        this.generateScript(builder, "exo:type", "locale");
        this.generateScript(builder, "exo:resourceName", q.getName());
        this.generateScript(builder, "exo:resourceLanguage", q.getLanguage());
        Session session = regNode.getSession();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        javax.jcr.query.Query query = queryManager.createQuery(builder.toString(), "sql");
        QueryResult result = query.execute();
        NodeIterator itr = result.getNodes();
        ArrayList<ResourceBundleData> resources = new ArrayList<ResourceBundleData>();
        while (itr.hasNext()) {
            String entryPath = itr.nextNode().getPath().substring(regNode.getPath().length() + 1);
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
            ResourceBundleData data = this.mapper_.toResourceBundleData(entry.getDocument());
            resources.add(data);
        }
        sessionProvider.close();
        return new ObjectPageList(resources, 20);
    }

    protected ResourceBundle getResourceBundleFromDb(String id, ResourceBundle parent, Locale locale) throws Exception {
        ResourceBundleData data = this.getResourceBundleData(id);
        if (data == null) {
            return null;
        }
        ExoResourceBundle res = new ExoResourceBundle(data.getData(), parent);
        MapResourceBundle mres = new MapResourceBundle((ResourceBundle)res, locale);
        return mres;
    }

    private void generateScript(StringBuilder sql, String name, String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        if (sql.indexOf(" where") < 0) {
            sql.append(" where ");
        } else {
            sql.append(" and ");
        }
        value = value.replace('*', '%');
        value = value.replaceAll("'", "&#39;");
        sql.append(name).append(" like '").append(value).append("'");
    }

    private String getServiceRegistryPath() {
        return "exo:services/ResourceBundles";
    }
}

