/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserACL {
    public static final String EVERYONE = "Everyone";
    protected static Log log = ExoLogger.getLogger((String)"organization:UserACL");
    private OrganizationService orgService_;
    private String superUser_;
    private String guestGroup_;
    private List<String> portalCreatorGroups_;
    private List<String> accessControlWorkspaceGroups_;
    private String navigationCreatorMembershipType_;

    public UserACL(InitParams params, OrganizationService orgService) throws Exception {
        ValueParam navCretorParam;
        this.orgService_ = orgService;
        ValueParam superUserParam = params.getValueParam("super.user");
        if (superUserParam != null) {
            this.superUser_ = superUserParam.getValue();
        }
        if (this.superUser_ == null || this.superUser_.trim().length() == 0) {
            this.superUser_ = "root";
        }
        String accessControlWorkspace = "";
        ValueParam accessControlWorkspaceParam = params.getValueParam("access.control.workspace");
        if (accessControlWorkspaceParam != null) {
            accessControlWorkspace = accessControlWorkspaceParam.getValue();
        }
        this.accessControlWorkspaceGroups_ = this.defragmentPermission(accessControlWorkspace);
        ValueParam guestGroupParam = params.getValueParam("guests.group");
        if (guestGroupParam != null) {
            this.guestGroup_ = guestGroupParam.getValue();
        }
        if (this.guestGroup_ == null || this.guestGroup_.trim().length() < 1) {
            this.guestGroup_ = "/platform/guests";
        }
        if ((navCretorParam = params.getValueParam("navigation.creator.membership.type")) != null) {
            this.navigationCreatorMembershipType_ = navCretorParam.getValue();
        }
        if (this.navigationCreatorMembershipType_ == null || this.navigationCreatorMembershipType_.trim().length() == 0) {
            this.navigationCreatorMembershipType_ = "owner";
        }
        String allGroups = "";
        ValueParam portalCretorGroupsParam = params.getValueParam("portal.creator.groups");
        if (portalCretorGroupsParam != null) {
            allGroups = portalCretorGroupsParam.getValue();
        }
        this.portalCreatorGroups_ = this.defragmentPermission(allGroups);
    }

    private List<String> defragmentPermission(String permission) {
        ArrayList<String> result = new ArrayList<String>();
        if (permission != null) {
            if (permission.contains(",")) {
                String[] groups;
                for (String group : groups = permission.split(",")) {
                    result.add(group.trim());
                }
            } else {
                result.add(permission);
            }
        }
        return result;
    }

    public String getMakableMT() {
        return this.navigationCreatorMembershipType_;
    }

    public List<String> getPortalCreatorGroups() {
        return this.portalCreatorGroups_;
    }

    public List<String> getAccessControlWorkspaceGroups() {
        return this.accessControlWorkspaceGroups_;
    }

    public String getSuperUser() {
        return this.superUser_;
    }

    public String getGuestsGroup() {
        return this.guestGroup_;
    }

    public boolean hasPermission(PortalConfig pconfig, String remoteUser) throws Exception {
        String[] accessPerms;
        if (this.hasEditPermission(pconfig, remoteUser)) {
            pconfig.setModifiable(true);
            return true;
        }
        pconfig.setModifiable(false);
        for (String per : accessPerms = pconfig.getAccessPermissions()) {
            if (!this.hasPermission(remoteUser, per)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Page page, String remoteUser) throws Exception {
        String[] accessPerms;
        if ("user".equals(page.getOwnerType())) {
            if (remoteUser.equals(page.getOwnerId())) {
                page.setModifiable(true);
                return true;
            }
            return false;
        }
        if (this.superUser_.equals(remoteUser)) {
            page.setModifiable(true);
            return true;
        }
        if (this.hasEditPermission(page, remoteUser)) {
            page.setModifiable(true);
            return true;
        }
        page.setModifiable(false);
        for (String per : accessPerms = page.getAccessPermissions()) {
            if (!this.hasPermission(remoteUser, per)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(String remoteUser, String expPerm) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("------CheckPermission of User " + remoteUser + " with membership " + expPerm));
        }
        if (this.superUser_.equals(remoteUser)) {
            return true;
        }
        if (expPerm == null) {
            return false;
        }
        if (EVERYONE.equals(expPerm)) {
            return true;
        }
        Permission permission = new Permission();
        permission.setPermissionExpression(expPerm);
        String groupId = permission.getGroupId();
        if (remoteUser == null && groupId.equals(this.guestGroup_)) {
            return true;
        }
        String membership = permission.getMembership();
        MembershipHandler handler = this.orgService_.getMembershipHandler();
        if (membership == null || "*".equals(membership)) {
            Collection c = handler.findMembershipsByUserAndGroup(remoteUser, groupId);
            if (c == null) {
                return false;
            }
            return c.size() > 0;
        }
        return handler.findMembershipByUserGroupAndType(remoteUser, groupId, membership) != null;
    }

    public boolean hasCreatePortalPermission(String remoteUser) throws Exception {
        if (this.superUser_.equals(remoteUser)) {
            return true;
        }
        if (this.portalCreatorGroups_ == null || this.portalCreatorGroups_.size() < 1) {
            return false;
        }
        for (String ele : this.portalCreatorGroups_) {
            if (!this.hasPermission(remoteUser, ele)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEditPermission(PortalConfig pconfig, String remoteUser) throws Exception {
        if (this.superUser_.equals(remoteUser)) {
            return true;
        }
        return this.hasPermission(remoteUser, pconfig.getEditPermission());
    }

    public boolean hasEditPermission(PageNavigation pageNav, String remoteUser) throws Exception {
        if (this.superUser_.equals(remoteUser)) {
            pageNav.setModifiable(true);
            return true;
        }
        String ownerType = pageNav.getOwnerType();
        if ("group".equals(ownerType)) {
            String expPerm = this.navigationCreatorMembershipType_ + ":/" + pageNav.getOwnerId();
            return this.hasPermission(remoteUser, expPerm);
        }
        if ("user".equals(ownerType)) {
            return remoteUser.equals(pageNav.getOwnerId());
        }
        return false;
    }

    public boolean hasEditPermission(Page page, String remoteUser) throws Exception {
        if ("user".equals(page.getOwnerType())) {
            if (remoteUser.equals(page.getOwnerId())) {
                page.setModifiable(true);
                return true;
            }
            return false;
        }
        if (this.hasPermission(remoteUser, page.getEditPermission())) {
            page.setModifiable(true);
            return true;
        }
        page.setModifiable(false);
        return false;
    }

    public boolean hasAccessControlWorkspacePermission(String remoteUser) throws Exception {
        if (this.superUser_.equals(remoteUser)) {
            return true;
        }
        if (this.accessControlWorkspaceGroups_ == null || this.accessControlWorkspaceGroups_.size() < 1) {
            return false;
        }
        for (String ele : this.accessControlWorkspaceGroups_) {
            if (!this.hasPermission(remoteUser, ele)) continue;
            return true;
        }
        return false;
    }

    public static class Permission {
        private String name_;
        private String groupId_ = "";
        private String membership_ = "";
        private String expression;
        private boolean selected_ = false;

        public void setPermissionExpression(String exp) {
            if (exp == null || exp.length() == 0) {
                return;
            }
            String[] temp = exp.split(":");
            if (temp.length < 2) {
                return;
            }
            this.expression = exp;
            this.membership_ = temp[0].trim();
            this.groupId_ = temp[1].trim();
        }

        public String getGroupId() {
            return this.groupId_;
        }

        public void setGroupId(String groupId) {
            this.groupId_ = groupId;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }

        public String getValue() {
            if (this.membership_.length() == 0 || this.groupId_.length() == 0) {
                return null;
            }
            return this.membership_ + ":" + this.groupId_;
        }

        public String getMembership() {
            return this.membership_;
        }

        public void setMembership(String membership) {
            this.membership_ = membership;
        }

        public boolean isSelected() {
            return this.selected_;
        }

        public void setSelected(boolean selected) {
            this.selected_ = selected;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }
}

