/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExpireKeyStartWithSelector;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletPreferencesImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.persistenceImp.PersistenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPortalConfigService {
    private DataStorage storage_;
    private UserACL userACL_;
    private OrganizationService orgService_;
    protected ExoCache portalConfigCache_;
    protected ExoCache pageConfigCache_;
    protected ExoCache pageNavigationCache_;
    protected ExoCache widgetsCache_;
    private NewPortalConfigListener newPortalConfigListener_;

    public UserPortalConfigService(UserACL userACL, DataStorage storage, CacheService cacheService, OrganizationService orgService) throws Exception {
        this.storage_ = storage;
        this.orgService_ = orgService;
        this.userACL_ = userACL;
        this.portalConfigCache_ = cacheService.getCacheInstance(PortalConfig.class.getName());
        this.pageConfigCache_ = cacheService.getCacheInstance(Page.class.getName());
        this.pageNavigationCache_ = cacheService.getCacheInstance(PageNavigation.class.getName());
        this.widgetsCache_ = cacheService.getCacheInstance(Widgets.class.getName());
    }

    public UserPortalConfig getUserPortalConfig(String portalName, String accessUser) throws Exception {
        PortalConfig portal = (PortalConfig)this.portalConfigCache_.get((Serializable)((Object)portalName));
        if (portal == null && (portal = this.storage_.getPortalConfig(portalName)) != null) {
            this.portalConfigCache_.put((Serializable)((Object)portalName), (Object)portal);
        }
        if (portal == null || !this.userACL_.hasPermission(portal, accessUser)) {
            return null;
        }
        ArrayList<PageNavigation> navigations = new ArrayList<PageNavigation>();
        PageNavigation navigation = this.getPageNavigation("portal::" + portalName);
        if (navigation != null) {
            navigation.setModifiable(this.userACL_.hasEditPermission(portal, accessUser));
            navigations.add(navigation);
        }
        if (accessUser == null) {
            navigation = this.getPageNavigation("group::" + this.userACL_.getGuestsGroup());
            if (navigation != null) {
                navigations.add(navigation);
            }
        } else {
            navigation = this.getPageNavigation("user::" + accessUser);
            if (navigation != null) {
                navigation.setModifiable(true);
                navigations.add(navigation);
            }
            Collection groups = null;
            groups = this.userACL_.getSuperUser().equals(accessUser) ? this.orgService_.getGroupHandler().getAllGroups() : this.orgService_.getGroupHandler().findGroupsOfUser(accessUser);
            for (Group m : groups) {
                String groupId = m.getId().trim();
                navigation = this.getPageNavigation("group::" + groupId);
                if (navigation == null) continue;
                navigation.setModifiable(this.userACL_.hasEditPermission(navigation, accessUser));
                navigations.add(navigation);
            }
        }
        Widgets userWidgets = this.getWidgets("user::" + accessUser);
        Collections.sort(navigations, new Comparator<PageNavigation>(){

            @Override
            public int compare(PageNavigation nav1, PageNavigation nav2) {
                return nav1.getPriority() - nav2.getPriority();
            }
        });
        return new UserPortalConfig(portal, navigations, userWidgets);
    }

    public List<String> getMakableNavigations(String remoteUser) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Collection groups = null;
        groups = remoteUser.equals(this.userACL_.getSuperUser()) ? this.orgService_.getGroupHandler().getAllGroups() : this.orgService_.getGroupHandler().findGroupByMembership(remoteUser, this.userACL_.getMakableMT());
        if (groups != null) {
            for (Group m : groups) {
                String groupId = m.getId().trim();
                if (groupId.charAt(0) == '/') {
                    groupId = groupId.substring(1);
                }
                list.add(groupId);
            }
        }
        return list;
    }

    public void createUserPortalConfig(String portalName, String template) throws Exception {
        NewPortalConfig portalConfig = this.newPortalConfigListener_.getPortalConfig("portal");
        portalConfig.setTemplateOwner(template);
        portalConfig.getPredefinedOwner().clear();
        portalConfig.getPredefinedOwner().add(portalName);
        this.newPortalConfigListener_.initPortalTypeDB(portalConfig);
    }

    public void removeUserPortalConfig(String portalName) throws Exception {
        int i;
        Query<Page> query = new Query<Page>(null, null, null, Page.class);
        query.setOwnerType("portal");
        query.setOwnerId(portalName);
        PageList pageList = this.storage_.find(query);
        pageList.setPageSize(10);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            for (Page page : list) {
                this.remove(page);
            }
        }
        String id = "portal::" + portalName;
        PageNavigation navigation = this.storage_.getPageNavigation(id);
        if (navigation != null) {
            this.remove(navigation);
        }
        Query<PortletPreferences> portletPrefQuery = new Query<PortletPreferences>(null, null, null, PortletPreferences.class);
        portletPrefQuery.setOwnerType("portal");
        portletPrefQuery.setOwnerId(portalName);
        pageList = this.storage_.find(portletPrefQuery);
        pageList.setPageSize(10);
        for (i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            for (PortletPreferences portletPreferences : list) {
                this.storage_.remove(portletPreferences);
            }
        }
        PortalConfig config = this.storage_.getPortalConfig(portalName);
        this.portalConfigCache_.remove((Serializable)((Object)config.getName()));
        if (config != null) {
            this.storage_.remove(config);
        }
    }

    public void update(PortalConfig portal) throws Exception {
        this.storage_.save(portal);
        this.portalConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(portal.getName()));
    }

    public Page getPage(String pageId, String accessUser) throws Exception {
        Page page = (Page)this.pageConfigCache_.get((Serializable)((Object)pageId));
        if (page == null) {
            page = this.storage_.getPage(pageId);
        }
        if (page == null || !this.userACL_.hasPermission(page, accessUser)) {
            return null;
        }
        this.pageConfigCache_.put((Serializable)((Object)pageId), (Object)page);
        return page;
    }

    public void remove(Page page) throws Exception {
        this.storage_.remove(page);
        this.pageConfigCache_.remove((Serializable)((Object)page.getPageId()));
    }

    public void create(Page page) throws Exception {
        this.storage_.create(page);
        this.pageConfigCache_.put((Serializable)((Object)page.getPageId()), (Object)page);
    }

    public void update(Page page) throws Exception {
        this.storage_.save(page);
        this.pageConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(page.getPageId()));
    }

    public void create(PageNavigation navigation) throws Exception {
        this.storage_.create(navigation);
        this.pageNavigationCache_.put((Serializable)((Object)navigation.getId()), (Object)navigation);
    }

    public void update(PageNavigation navigation) throws Exception {
        this.storage_.save(navigation);
        this.pageNavigationCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(navigation.getId()));
    }

    public void remove(PageNavigation navigation) throws Exception {
        this.storage_.remove(navigation);
        this.pageNavigationCache_.remove((Serializable)((Object)navigation.getId()));
    }

    public PageNavigation getPageNavigation(String id) throws Exception {
        PageNavigation navigation = (PageNavigation)this.pageNavigationCache_.get((Serializable)((Object)id));
        if (navigation == null) {
            navigation = this.storage_.getPageNavigation(id);
        }
        return navigation;
    }

    public void create(Widgets widgets) throws Exception {
        this.storage_.create(widgets);
        this.widgetsCache_.put((Serializable)((Object)widgets.getId()), (Object)widgets);
    }

    public void update(Widgets widgets) throws Exception {
        this.storage_.save(widgets);
        this.widgetsCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(widgets.getId()));
    }

    public void remove(Widgets widgets) throws Exception {
        this.storage_.remove(widgets);
        this.widgetsCache_.remove((Serializable)((Object)widgets.getId()));
    }

    public Widgets getWidgets(String id) throws Exception {
        Widgets widgets = (Widgets)this.pageConfigCache_.get((Serializable)((Object)id));
        if (widgets != null) {
            return widgets;
        }
        widgets = this.storage_.getWidgets(id);
        this.widgetsCache_.put((Serializable)((Object)id), (Object)widgets);
        return widgets;
    }

    public PageNode createNodeFromPageTemplate(String nodeName, String nodeLabel, String pageId, Map<String, String[]> portletPreferences, String accessUser) throws Exception {
        Page page = this.storage_.getPage(pageId);
        page = this.createPageFromPageTemplate(page, nodeName, portletPreferences, accessUser);
        this.create(page);
        PageNode pageNode = new PageNode();
        if (nodeLabel == null || nodeLabel.trim().length() < 1) {
            nodeLabel = nodeName;
        }
        pageNode.setName(nodeName);
        pageNode.setLabel(nodeLabel);
        pageNode.setPageReference(page.getPageId());
        return pageNode;
    }

    private Page createPageFromPageTemplate(Page page, String pageName, Map<String, String[]> portletPreferences, String accessUser) throws Exception {
        String newId = "user::" + accessUser + "::" + pageName;
        page.setName(pageName);
        page.setPageId(newId);
        page.setOwnerType("user");
        page.setOwnerId(accessUser);
        page.setAccessPermissions(null);
        page.setEditPermission(null);
        ArrayList<Application> apps = new ArrayList<Application>(5);
        this.getApplications(apps, page);
        for (Application ele : apps) {
            String appType = ele.getApplicationType();
            if (appType == null || appType.equals("portlet")) {
                HashMap<String, String[]> mergedPreferences = new HashMap<String, String[]>(UserPortalConfigService.getPreferencesMap(ele));
                mergedPreferences.putAll(portletPreferences);
                UserPortalConfigService.renewInstanceId(ele, accessUser);
                UserPortalConfigService.setPreferences(ele, mergedPreferences);
                continue;
            }
            UserPortalConfigService.renewInstanceId(ele, accessUser);
        }
        return page;
    }

    private void getApplications(List<Application> apps, Object component) {
        Container container;
        ArrayList<Object> children;
        if (component instanceof Application) {
            apps.add((Application)component);
        } else if (component instanceof Container && (children = (container = (Container)component).getChildren()) != null) {
            for (Object e : children) {
                this.getApplications(apps, e);
            }
        }
    }

    private static Map<String, String[]> getPreferencesMap(Application app) throws Exception {
        ExoWindowID windowID = new ExoWindowID(app.getInstanceId());
        Input input = new Input();
        input.setInternalWindowID((WindowID)windowID);
        PortalContainer container = PortalContainer.getInstance();
        PortletApplicationsHolder holder = (PortletApplicationsHolder)container.getComponentInstanceOfType(PortletApplicationsHolder.class);
        Portlet pDatas = holder.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PersistenceManager manager = (PersistenceManager)container.getComponentInstanceOfType(PersistenceManager.class);
        PortletWindowInternal windowInfos = manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        return preferences.getMap();
    }

    private static void renewInstanceId(Application portlet, String ownerId) {
        ExoWindowID newExoWindowID = new ExoWindowID(portlet.getInstanceId());
        newExoWindowID.setOwner("user#" + ownerId);
        newExoWindowID.setUniqueID(String.valueOf(newExoWindowID.hashCode()));
        portlet.setInstanceId(newExoWindowID.generatePersistenceId());
    }

    private static void setPreferences(Application portlet, Map<String, String[]> portletPreferences) throws Exception {
        if (portletPreferences == null || portletPreferences.size() < 1) {
            return;
        }
        ExoWindowID windowID = new ExoWindowID(portlet.getInstanceId());
        Input input = new Input();
        input.setInternalWindowID((WindowID)windowID);
        PortalContainer container = PortalContainer.getInstance();
        PortletApplicationsHolder holder = (PortletApplicationsHolder)container.getComponentInstanceOfType(PortletApplicationsHolder.class);
        Portlet pDatas = holder.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PersistenceManager manager = (PersistenceManager)container.getComponentInstanceOfType(PersistenceManager.class);
        PortletWindowInternal windowInfos = manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        for (Map.Entry<String, String[]> entry : portletPreferences.entrySet()) {
            preferences.setValues(entry.getKey(), entry.getValue());
        }
        preferences.setMethodCalledIsAction(1);
        preferences.store();
    }

    public void initListener(ComponentPlugin listener) {
        if (listener instanceof NewPortalConfigListener) {
            this.newPortalConfigListener_ = (NewPortalConfigListener)listener;
        }
    }

    public String getDefaultPortal() {
        return this.newPortalConfigListener_.getDefaultPortal();
    }
}

