/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Widgets;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMapper {
    private static final String DATA_ELEMENT = "data";
    public static final String EXO_REGISTRYENTRY_NT = "exo:registryEntry";
    public static final String TYPE = "jcr:primaryType";
    public static final String EXO_ID = "exo:id";
    public static final String EXO_NAME = "exo:name";
    public static final String EXO_OWNER_TYPE = "exo:ownerType";
    public static final String EXO_OWNER_ID = "exo:ownerId";
    public static final String EXO_DATA_TYPE = "exo:dataType";

    public void map(Document doc, PortalConfig portal) throws Exception {
        Element root = doc.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(TYPE, EXO_REGISTRYENTRY_NT);
        root.setAttribute(EXO_ID, portal.getName());
        root.setAttribute(EXO_NAME, portal.getName());
        root.setAttribute(EXO_OWNER_TYPE, "portal");
        root.setAttribute(EXO_OWNER_ID, "portalConfig");
        root.setAttribute(EXO_DATA_TYPE, portal.getClass().getSimpleName());
        this.setDataValue(doc, DATA_ELEMENT, this.toXML(portal));
    }

    public PortalConfig toPortalConfig(Document doc) throws Exception {
        String data = this.getDataValue(doc, DATA_ELEMENT);
        return this.fromXML(data, PortalConfig.class);
    }

    public void map(Document doc, Page page) throws Exception {
        Element root = doc.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(TYPE, EXO_REGISTRYENTRY_NT);
        root.setAttribute(EXO_ID, page.getPageId());
        root.setAttribute(EXO_NAME, page.getName());
        root.setAttribute(EXO_OWNER_TYPE, page.getOwnerType());
        root.setAttribute(EXO_OWNER_ID, page.getOwnerId());
        root.setAttribute(EXO_DATA_TYPE, page.getClass().getSimpleName());
        this.setDataValue(doc, DATA_ELEMENT, this.toXML(page));
    }

    public Page toPageConfig(Document doc) throws Exception {
        String data = this.getDataValue(doc, DATA_ELEMENT);
        return this.fromXML(data, Page.class);
    }

    public void map(Document doc, PageNavigation navigation) throws Exception {
        Element root = doc.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(TYPE, EXO_REGISTRYENTRY_NT);
        root.setAttribute(EXO_ID, navigation.getId());
        root.setAttribute(EXO_NAME, navigation.getId());
        root.setAttribute(EXO_OWNER_TYPE, navigation.getOwnerType());
        root.setAttribute(EXO_OWNER_ID, navigation.getOwnerId());
        root.setAttribute(EXO_DATA_TYPE, navigation.getClass().getSimpleName());
        this.setDataValue(doc, DATA_ELEMENT, this.toXML(navigation));
    }

    public PageNavigation toPageNavigation(Document doc) throws Exception {
        String data = this.getDataValue(doc, DATA_ELEMENT);
        return this.fromXML(data, PageNavigation.class);
    }

    public void map(Document doc, Widgets widgets) throws Exception {
        Element root = doc.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(TYPE, EXO_REGISTRYENTRY_NT);
        root.setAttribute(EXO_ID, widgets.getId());
        root.setAttribute(EXO_NAME, widgets.getId());
        root.setAttribute(EXO_OWNER_TYPE, widgets.getOwnerType());
        root.setAttribute(EXO_OWNER_ID, widgets.getOwnerId());
        root.setAttribute(EXO_DATA_TYPE, widgets.getClass().getSimpleName());
        this.setDataValue(doc, DATA_ELEMENT, this.toXML(widgets));
    }

    public Widgets toWidgets(Document doc) throws Exception {
        String data = this.getDataValue(doc, DATA_ELEMENT);
        return this.fromXML(data, Widgets.class);
    }

    public void map(Document doc, PortletPreferences portletPreferences) throws Exception {
        Element root = doc.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(TYPE, EXO_REGISTRYENTRY_NT);
        root.setAttribute(EXO_ID, portletPreferences.getWindowId());
        root.setAttribute(EXO_NAME, portletPreferences.getWindowId().replace('/', '_').replace(':', '_').replace('#', '_'));
        root.setAttribute(EXO_OWNER_TYPE, portletPreferences.getOwnerType());
        root.setAttribute(EXO_OWNER_ID, portletPreferences.getOwnerId());
        root.setAttribute(EXO_DATA_TYPE, portletPreferences.getClass().getSimpleName());
        this.setDataValue(doc, DATA_ELEMENT, this.toXML(portletPreferences));
    }

    public PortletPreferences toPortletPreferences(Document doc) throws Exception {
        String data = this.getDataValue(doc, DATA_ELEMENT);
        return this.fromXML(data, PortletPreferences.class);
    }

    public <T> T fromDocument(Document doc, Class<T> clazz) throws Exception {
        String data = this.getDataValue(doc, DATA_ELEMENT);
        return this.fromXML(data, clazz);
    }

    private void prepareXmlNamespace(Element element) {
        this.setXmlNameSpace(element, "xmlns:exo", "http://www.exoplatform.com/jcr/exo/1.0");
        this.setXmlNameSpace(element, "xmlns:jcr", "http://www.jcp.org/jcr/1.0");
    }

    private void setXmlNameSpace(Element element, String key, String value) {
        String xmlns = element.getAttribute(key);
        if (xmlns == null || xmlns.trim().length() < 1) {
            element.setAttribute(key, value);
        }
    }

    private void setDataValue(Document doc, String name, String value) {
        Node child;
        Element dataElement = this.createDataElement(doc, name);
        while ((child = dataElement.getFirstChild()) != null) {
            dataElement.removeChild(child);
        }
        CDATASection data = doc.createCDATASection(value);
        dataElement.appendChild(data);
    }

    private String getDataValue(Document doc, String name) {
        Element dataElement = this.createDataElement(doc, name);
        return dataElement.getFirstChild().getNodeValue();
    }

    private Element createDataElement(Document doc, String name) {
        Element ele = (Element)doc.getElementsByTagName(name).item(0);
        if (ele == null) {
            ele = doc.createElement(name);
            doc.getDocumentElement().appendChild(ele);
        }
        return ele;
    }

    private String toXML(Object object) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IBindingFactory bfact = BindingDirectory.getFactory(object.getClass());
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        mctx.marshalDocument(object, "UTF-8", null, (OutputStream)os);
        return new String(os.toByteArray(), "UTF-8");
    }

    private <T> T fromXML(String xml, Class<T> clazz) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        IBindingFactory bfact = BindingDirectory.getFactory(clazz);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return clazz.cast(uctx.unmarshalDocument((InputStream)is, null));
    }
}

