/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.SlidePersistAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;

public class SLWTTextListing {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShow ss = new HSLFSlideShow(args[0]);
        Record[] records = ss.getRecords();
        for (int i = 0; i < records.length; ++i) {
            if (records[i].getRecordType() != 1000L) continue;
            Record docRecord = records[i];
            Record[] docChildren = docRecord.getChildRecords();
            for (int j = 0; j < docChildren.length; ++j) {
                if (!(docChildren[j] instanceof SlideListWithText)) continue;
                System.out.println("Found SLWT in document at " + i);
                System.out.println("  Has " + docChildren[j].getChildRecords().length + " children");
                SlideListWithText slwt = (SlideListWithText)docChildren[j];
                SlideListWithText.SlideAtomsSet[] thisSets = slwt.getSlideAtomsSets();
                System.out.println("  Has " + thisSets.length + " AtomSets in it");
                for (int k = 0; k < thisSets.length; ++k) {
                    SlidePersistAtom spa = thisSets[k].getSlidePersistAtom();
                    System.out.println("    " + k + " has slide id " + spa.getSlideIdentifier());
                    System.out.println("    " + k + " has ref id " + spa.getRefID());
                    Record[] slwtc = thisSets[k].getSlideRecords();
                    for (int l = 0; l < slwtc.length; ++l) {
                        String text = null;
                        if (slwtc[l] instanceof TextBytesAtom) {
                            TextBytesAtom tba = (TextBytesAtom)slwtc[l];
                            text = tba.getText();
                        }
                        if (slwtc[l] instanceof TextCharsAtom) {
                            TextCharsAtom tca = (TextCharsAtom)slwtc[l];
                            text = tca.getText();
                        }
                        if (text == null) continue;
                        text = text.replace('\r', '\n');
                        System.out.println("        ''" + text + "''");
                    }
                }
            }
        }
    }
}

