/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.services.log.LogMessage;

public class ExoLog
implements Log {
    public static int FATAL = 0;
    public static int ERROR = 1;
    public static int WARN = 2;
    public static int INFO = 3;
    public static int DEBUG = 4;
    public static int TRACE = 5;
    static final String EXO_PREFIX = " - ";
    private static Log log_ = LogFactory.getLog((String)"eXo");
    public static int LOG_BUFFER_SIZE = 2000;
    public static int ERROR_BUFFER_SIZE = 1500;
    private static List logBuffer_;
    private static List errorBuffer_;
    private String category_;
    private int level_;
    private String prefix_;

    public ExoLog(String name, int level) {
        this.category_ = name;
        this.level_ = level;
        int index = name.lastIndexOf(".");
        String nameSuffix = name;
        if (index > 0) {
            nameSuffix = name.substring(index + 1, name.length());
        }
        this.prefix_ = " - [" + nameSuffix + "] ";
    }

    public String getLogCategory() {
        return this.category_;
    }

    public int getLevel() {
        return this.level_;
    }

    public void setLevel(int level) {
        this.level_ = level;
    }

    public void trace(Object message) {
        log_.trace((Object)(this.prefix_ + message));
    }

    public void trace(Object message, Throwable t) {
        log_.trace((Object)(this.prefix_ + message), t);
    }

    public void debug(Object message) {
        if (this.level_ >= DEBUG) {
            log_.debug((Object)(this.prefix_ + message));
            this.addLogMessage(new LogMessage(this.prefix_, DEBUG, message.toString(), null));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.level_ >= DEBUG) {
            log_.debug((Object)(this.prefix_ + message), t);
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            this.addLogMessage(new LogMessage(this.prefix_, DEBUG, message.toString(), strace));
        }
    }

    public void info(Object message) {
        if (this.level_ >= INFO) {
            log_.info((Object)(this.prefix_ + message));
            this.addLogMessage(new LogMessage(this.prefix_, INFO, message.toString(), null));
        }
    }

    public void info(Object message, Throwable t) {
        if (this.level_ >= INFO) {
            log_.info((Object)(this.prefix_ + message), t);
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            this.addLogMessage(new LogMessage(this.prefix_, INFO, message.toString(), strace));
        }
    }

    public void warn(Object message) {
        if (this.level_ >= WARN) {
            log_.warn((Object)(this.prefix_ + message));
            this.addLogMessage(new LogMessage(this.prefix_, WARN, message.toString(), null));
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.level_ >= WARN) {
            log_.warn((Object)(this.prefix_ + message), t);
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            this.addLogMessage(new LogMessage(this.prefix_, WARN, message.toString(), strace));
        }
    }

    public void error(Object message) {
        if (this.level_ >= ERROR) {
            log_.error((Object)(this.prefix_ + message));
            this.addLogMessage(new LogMessage(this.prefix_, ERROR, message.toString(), null));
        }
    }

    public void error(Object message, Throwable t) {
        if (this.level_ >= ERROR) {
            log_.error((Object)(this.prefix_ + message), t);
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            this.addLogMessage(new LogMessage(this.prefix_, ERROR, message.toString(), strace));
        }
    }

    public void fatal(Object message) {
        if (this.level_ >= FATAL) {
            log_.fatal((Object)(this.prefix_ + message));
            this.addLogMessage(new LogMessage(this.prefix_, FATAL, message.toString(), null));
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.level_ >= FATAL) {
            log_.fatal((Object)(this.prefix_ + message), t);
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            this.addLogMessage(new LogMessage(this.prefix_, FATAL, message.toString(), strace));
        }
    }

    public final boolean isDebugEnabled() {
        return this.level_ >= DEBUG;
    }

    public final boolean isErrorEnabled() {
        return this.level_ >= ERROR;
    }

    public final boolean isFatalEnabled() {
        return this.level_ >= FATAL;
    }

    public final boolean isInfoEnabled() {
        return this.level_ >= INFO;
    }

    public final boolean isTraceEnabled() {
        return this.level_ >= TRACE;
    }

    public final boolean isWarnEnabled() {
        return this.level_ >= WARN;
    }

    private void addLogMessage(LogMessage lm) {
        int i;
        ArrayList list;
        ExoLog.getLogBuffer().add(lm);
        if (ExoLog.getLogBuffer().size() == LOG_BUFFER_SIZE * 2) {
            list = new ArrayList(LOG_BUFFER_SIZE * 2);
            for (i = LOG_BUFFER_SIZE; i < ExoLog.getLogBuffer().size(); ++i) {
                list.add(ExoLog.getLogBuffer().get(i));
            }
            logBuffer_ = list;
        }
        if (lm.getType() == ERROR) {
            ExoLog.getErrorBuffer().add(lm);
            if (ExoLog.getErrorBuffer().size() == ERROR_BUFFER_SIZE * 2) {
                list = new ArrayList(ERROR_BUFFER_SIZE * 2);
                for (i = ERROR_BUFFER_SIZE; i < ExoLog.getErrorBuffer().size(); ++i) {
                    list.add(ExoLog.getErrorBuffer().get(i));
                }
                errorBuffer_ = list;
            }
        }
    }

    public static List getLogBuffer() {
        if (logBuffer_ == null) {
            LOG_BUFFER_SIZE = 2000;
            logBuffer_ = new ArrayList(LOG_BUFFER_SIZE * 2);
        }
        return logBuffer_;
    }

    public static List getErrorBuffer() {
        if (errorBuffer_ == null) {
            ERROR_BUFFER_SIZE = 1500;
            errorBuffer_ = new ArrayList(ERROR_BUFFER_SIZE * 2);
        }
        return errorBuffer_;
    }
}

