/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;

public class ExoBroadcastJAASLoginModule
implements LoginModule {
    private Log log = ExoLogger.getLogger((String)"kernel.ExoBroadcastJAASLoginModule");
    private Subject subject_;
    private Map sharedState_;
    private PortalContainer cachedContainer_ = null;

    public ExoContainer getContainer() throws Exception {
        return RootContainer.getInstance().getPortalContainer("portal");
    }

    public void preProcessOperations() throws Exception {
        this.cachedContainer_ = PortalContainer.getInstance();
        PortalContainer container = this.cachedContainer_;
        if (container == null) {
            container = (PortalContainer)this.getContainer();
            PortalContainer.setInstance((PortalContainer)container);
        }
        List components = container.getComponentInstancesOfType(ComponentRequestLifecycle.class);
        for (ComponentRequestLifecycle component : components) {
            component.startRequest((ExoContainer)container);
        }
    }

    public void postProcessOperations() throws Exception {
        PortalContainer container = (PortalContainer)this.getContainer();
        List components = container.getComponentInstancesOfType(ComponentRequestLifecycle.class);
        if (components != null) {
            for (ComponentRequestLifecycle component : components) {
                component.endRequest((ExoContainer)container);
            }
        }
        PortalContainer.setInstance((PortalContainer)this.cachedContainer_);
    }

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject_ = subject;
        this.sharedState_ = sharedState;
    }

    public final boolean login() throws LoginException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean commit() throws LoginException {
        boolean bl;
        try {
            String username = (String)this.sharedState_.get("javax.security.auth.login.name");
            ExoContainer container = this.getContainer();
            this.preProcessOperations();
            AuthenticationService authService = (AuthenticationService)container.getComponentInstanceOfType(AuthenticationService.class);
            Identity identity = new Identity(username, username, this.subject_);
            authService.broadcastAuthentication(identity);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.postProcessOperations();
                throw throwable;
            }
            catch (Exception e) {
                throw new LoginException("Authentication failed. Exception " + e);
            }
        }
        this.postProcessOperations();
        return bl;
    }

    public final boolean abort() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In abort of TomcatLoginModule");
        }
        return true;
    }

    public final boolean logout() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In logout of TomcatLoginModule, It seems this method is never called in tomcat");
        }
        return true;
    }
}

