/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;
import org.exoplatform.services.organization.auth.RolePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatAuthenticationListener
extends Listener<AuthenticationService, Identity> {
    private String userRoleParentGroup = null;

    public TomcatAuthenticationListener(InitParams params) {
        ValueParam param;
        if (params != null && (param = params.getValueParam("user.role.parent.group")) != null && param.getValue().length() > 0) {
            this.userRoleParentGroup = param.getValue();
        }
    }

    public void onEvent(Event<AuthenticationService, Identity> event) throws Exception {
        Identity identity = (Identity)event.getData();
        Subject subject = identity.getSubject();
        OrganizationService service = ((AuthenticationService)event.getSource()).getOrganizationService();
        Set<Principal> principals = subject.getPrincipals();
        Collection groups = service.getGroupHandler().findGroupsOfUser(identity.getUsername());
        for (Group group : groups) {
            String groupId = group.getId();
            String[] splittedGroupName = StringUtils.split((String)groupId, (String)"/");
            if (this.userRoleParentGroup != null && splittedGroupName[0].equals(this.userRoleParentGroup) && splittedGroupName.length > 1) {
                principals.add(new RolePrincipal(splittedGroupName[splittedGroupName.length - 1]));
                continue;
            }
            principals.add(new RolePrincipal(splittedGroupName[0]));
        }
    }
}

