/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;

public class SetCurrentIdentityFilter
implements Filter {
    private static Log log = ExoLogger.getLogger((String)"auth.web.RestFilter");
    private ServletContext servletContext;
    private String userId = null;

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession httpSession = httpRequest.getSession();
        String portalName = this.servletContext.getServletContextName();
        ExoContainer container = ExoContainerContext.getContainerByName((String)portalName);
        if (container == null) {
            container = ExoContainerContext.getTopContainer();
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        AuthenticationService authenticationService = (AuthenticationService)container.getComponentInstanceOfType(AuthenticationService.class);
        Identity identity = null;
        if (httpRequest.getRemoteUser() != null) {
            try {
                identity = authenticationService.getIdentityBySessionId(httpRequest.getRemoteUser());
            }
            catch (Exception e) {
                log.error((Object)"Can't find identity by sessionID ", (Throwable)e);
            }
        }
        authenticationService.setCurrentIdentity(identity);
        chain.doFilter(request, response);
        authenticationService.setCurrentIdentity(null);
    }

    public void destroy() {
    }
}

