/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web.fckeditor;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.frameworks.jcr.JCRAppSessionFactory;
import org.exoplatform.frameworks.jcr.web.fckeditor.FCKeditor;

public class JCRContentFCKeditor
extends FCKeditor {
    private Node file;

    public JCRContentFCKeditor(HttpServletRequest req, String parInstanceName, String workspaceName, String filePath, String newNodeType) throws RepositoryException {
        super(req, parInstanceName);
        JCRAppSessionFactory factory = (JCRAppSessionFactory)req.getSession().getAttribute("org.exoplatform.frameworks.web.sessionFactory");
        Session session = factory.getSession(workspaceName);
        try {
            this.file = (Node)session.getItem(filePath);
        }
        catch (PathNotFoundException e1) {
            this.file = session.getRootNode().addNode(filePath.substring(1), newNodeType);
        }
        if (!this.file.isNodeType("nt:file")) {
            throw new RepositoryException("The Node should be nt:file type");
        }
        try {
            Property content = (Property)session.getItem(filePath + "/jcr:content/jcr:data");
            this.setValue(content.getString());
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public void saveValue(String value) throws RepositoryException {
        this.file.getNode("jcr:content").setProperty("jcr:data", value);
        this.setValue(value);
        this.file.getSession().save();
    }
}

