/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.portlet.ClientDataRequest;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientDataRequestImp
extends PortletRequestImp
implements ClientDataRequest {
    private boolean isCallGetReader = false;
    private boolean isCallGetStream = false;
    private boolean areParamsTouched = false;

    public ClientDataRequestImp(RequestContext reqCtx) {
        super(reqCtx);
    }

    @Override
    public final String getParameter(String name) {
        this.areParamsTouched = true;
        if (this.isCallGetReader || this.isCallGetStream) {
            return null;
        }
        return super.getParameter(name);
    }

    @Override
    public final Enumeration<String> getParameterNames() {
        this.areParamsTouched = true;
        if (this.isCallGetReader || this.isCallGetStream) {
            return new Vector().elements();
        }
        return super.getParameterNames();
    }

    @Override
    public final String[] getParameterValues(String name) {
        this.areParamsTouched = true;
        if (this.isCallGetReader || this.isCallGetStream) {
            return null;
        }
        return super.getParameterValues(name);
    }

    @Override
    public final Map<String, String[]> getParameterMap() {
        this.areParamsTouched = true;
        if (this.isCallGetReader || this.isCallGetStream) {
            return new HashMap<String, String[]>();
        }
        return super.getParameterMap();
    }

    public final byte[] makeFormDataByteArray() {
        if (this.areParamsTouched) {
            return new byte[0];
        }
        try {
            StringBuffer r = new StringBuffer();
            boolean touched = false;
            Enumeration<String> e = super.getParameterNames();
            while (e.hasMoreElements()) {
                String n = e.nextElement();
                String[] v = super.getParameterValues(n);
                if (v == null || v.length <= 0) continue;
                for (String element : v) {
                    if (touched) {
                        r.append("&");
                    } else {
                        touched = true;
                    }
                    String encToUse = this.enc;
                    if (encToUse == null) {
                        encToUse = "utf-8";
                    }
                    r.append(n + "=" + URLEncoder.encode(element, encToUse));
                }
            }
            return r.toString().getBytes("us-ascii");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public final InputStream getPortletInputStream() throws IOException {
        if (this.isCallGetReader) {
            throw new IllegalStateException("getPortletInputStream() cannot be called, when getReader() method has been called");
        }
        if (this.isCallGetStream) {
            throw new IllegalStateException("getPortletInputStream() cannot be called twice");
        }
        String contentType = this.getHeader("content-type");
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            if (!this.reqCtx.getPortletDatas().getApplication().getVer2() || !this.getMethod().equalsIgnoreCase("post")) {
                throw new IllegalStateException("content type cannot be application/x-www-form-urlencoded");
            }
            this.isCallGetStream = true;
            return new ByteArrayInputStream(this.makeFormDataByteArray());
        }
        this.isCallGetStream = true;
        return super.getInputStream();
    }

    public final BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.isCallGetReader) {
            throw new IllegalStateException("getPortletInputStream() cannot be called twice");
        }
        if (this.isCallGetStream) {
            throw new IllegalStateException("getReader() cannot be called, when getPortletInputStream() method has been called");
        }
        String contentType = this.getHeader("content-type");
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            if (!this.reqCtx.getPortletDatas().getApplication().getVer2() || !this.getMethod().equalsIgnoreCase("post")) {
                throw new IllegalStateException("content type cannot be application/x-www-form-urlencoded");
            }
            this.isCallGetReader = true;
            return new BufferedReader(new CharArrayReader(new String(this.makeFormDataByteArray(), "us-ascii").toCharArray()));
        }
        this.isCallGetReader = true;
        return super.getReader();
    }

    public final void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.isCallGetReader || this.isCallGetStream) {
            throw new IllegalStateException("This method cannot be called, when getReader() method has been called");
        }
        super.setCharacterEncoding(enc);
        this.enc = enc;
        this.encodingModified = true;
    }

    public final String getCharacterEncoding() {
        return super.getCharacterEncoding();
    }

    public final String getContentType() {
        return super.getContentType();
    }

    public final int getContentLength() {
        return super.getContentLength();
    }

    public String getMethod() {
        return super.getMethod();
    }

    public abstract String getLifecyclePhase();
}

